/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.math.BigInteger;
import java.nio.CharBuffer;

public class ProtocolUtil {
    public static final int HEXADECIMAL = 0;
    public static final int OCTAL = 1;
    public static final int BINARY = 2;
    public static final int DECIMAL = 3;
    public static final int RAW = 4;
    public static final int NATURAL = 5;
    public static final int FLOAT = 10;
    public static final int ADDRESS = 11;
    public static final int INSTRUCTION = 12;
    public static final int CHAR = 13;
    public static final int STRING = 14;
    public static final int UNSIGNED = 15;

    public static BigInteger decodeAddress(String address) {
        int index = 0;
        int radix = 10;
        boolean negative = false;
        if ((address = address.trim()).length() == 0) {
            return BigInteger.ZERO;
        }
        if (address.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (address.startsWith("0x", index) || address.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (address.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (address.startsWith("0", index) && address.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (index > 0) {
            address = address.substring(index);
        }
        if (negative) {
            address = "-" + address;
        }
        try {
            return new BigInteger(address, radix);
        }
        catch (NumberFormatException numberFormatException) {
            return BigInteger.ZERO;
        }
    }

    public static byte[] decodeBytes(String str) {
        int len = str.length() / 2;
        byte[] strBytes = new byte[len];
        int i = 0;
        int p = 0;
        while (i < len) {
            byte c = (byte)((Character.digit(str.charAt(p), 16) & 0xF) << 4);
            strBytes[i] = c = (byte)(c | (byte)(Character.digit(str.charAt(p + 1), 16) & 0xF));
            ++i;
            p += 2;
        }
        return strBytes;
    }

    public static String decodeString(CharBuffer buf, int start) {
        int end = start + 8;
        int len = Integer.parseInt(buf.subSequence(start, end).toString(), 16);
        start = end + 1;
        end = start + len;
        return buf.subSequence(start, end).toString();
    }

    public static String encodeIntVal(int val, int len) {
        char[] res = new char[len];
        String str = Integer.toHexString(val);
        int rem = len - str.length();
        int i = 0;
        while (i < len) {
            res[i] = i < rem ? 48 : str.charAt(i - rem);
            ++i;
        }
        return String.valueOf(res);
    }

    public static String encodeString(String str) {
        int len;
        if (str == null) {
            len = 0;
            str = "";
        } else {
            len = str.length();
        }
        return String.valueOf(ProtocolUtil.encodeIntVal(len, 8)) + ":" + str;
    }
}

