/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.MPIJobAttributes;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.core.utils.IInputStreamListener;
import org.eclipse.ptp.rm.core.utils.InputStreamListenerToOutputStream;
import org.eclipse.ptp.rm.core.utils.InputStreamObserver;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPILaunchAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.messages.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.IOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.IOpenMPIProcessMapParserListener;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPI13xInputStream;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIErrorParser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMapText12Parser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMapXml13Parser;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIRuntimeSystemJob
extends AbstractToolRuntimeSystemJob {
    private InputStreamObserver stderrObserver;
    private InputStreamObserver stdoutObserver;
    protected boolean errorDetected = false;
    protected String errorMessage = null;
    protected boolean mapCompleted = false;
    protected final ReentrantLock mapLock = new ReentrantLock();
    protected final Condition mapCondition = this.mapLock.newCondition();
    protected Exception parserException = null;
    protected InputStreamListenerToOutputStream parserListener;
    protected Thread parserThread;

    public OpenMPIRuntimeSystemJob(String jobID, String queueID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(jobID, queueID, name, rtSystem, attrMgr);
    }

    private void terminateProcesses() {
        IPJob ipJob;
        IPQueue queue;
        OpenMPIRuntimeSystem rtSystem = (OpenMPIRuntimeSystem)this.getRtSystem();
        IResourceManager rm = PTPCorePlugin.getDefault().getUniverse().getResourceManager(rtSystem.getRmID());
        if (rm != null && (queue = rm.getQueueById(this.getQueueID())) != null && (ipJob = queue.getJobById(this.getJobID())) != null) {
            AttributeManager attrMrg = new AttributeManager();
            attrMrg.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.COMPLETED));
            BitSet procJobRanks = ipJob.getProcessJobRanks();
            rtSystem.changeProcesses(ipJob.getID(), procJobRanks, attrMrg);
        }
    }

    protected void addProcess(IPJob job, OpenMPIProcessMap.Process proc) {
        String nodename;
        OpenMPIRuntimeSystem rts = (OpenMPIRuntimeSystem)this.getRtSystem();
        String nodeID = rts.getNodeIDforName(nodename = proc.getNode().getResolvedName());
        if (nodeID != null) {
            int processIndex = proc.getIndex();
            BitSet processIndices = new BitSet();
            processIndices.set(processIndex);
            AttributeManager attrMgr = new AttributeManager();
            attrMgr.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(nodeID));
            attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.RUNNING));
            attrMgr.addAttributes(proc.getAttributeManager().getAttributes());
            this.getRtSystem().changeProcesses(job.getID(), processIndices, attrMgr);
        }
    }

    protected void createParser(final IOpenMPIResourceManagerConfiguration configuration, final IPJob job) {
        PipedInputStream parserInputStream;
        PipedOutputStream parserOutputStream;
        block2: {
            parserOutputStream = new PipedOutputStream();
            parserInputStream = new PipedInputStream();
            try {
                parserInputStream.connect(parserOutputStream);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.setParserListener(new InputStreamListenerToOutputStream((OutputStream)parserOutputStream));
        this.parserThread = new Thread(){

            public void run() {
                block13: {
                    DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: started", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID()});
                    try {
                        try {
                            if (configuration.getDetectedVersion().equals("1.2")) {
                                OpenMPIProcessMapText12Parser.parse(parserInputStream, new IOpenMPIProcessMapParserListener(){

                                    public void finish() {
                                    }

                                    public void finishMap(AttributeManager manager) {
                                        if (manager.getAttributes().length > 0) {
                                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: updating model with display-map information", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID()});
                                            OpenMPIRuntimeSystemJob.this.getRtSystem().changeJob(OpenMPIRuntimeSystemJob.this.getJobID(), manager);
                                        }
                                        OpenMPIRuntimeSystemJob.this.setMapCompleted();
                                    }

                                    public void newProcess(OpenMPIProcessMap.Process proc) {
                                        OpenMPIRuntimeSystemJob.this.addProcess(job, proc);
                                    }

                                    public void start() {
                                    }

                                    public void stderr(OpenMPIProcessMap.Process proc, String output) {
                                    }

                                    public void stdout(OpenMPIProcessMap.Process proc, String output) {
                                    }
                                });
                            } else if (configuration.getDetectedVersion().equals("1.3") || configuration.getDetectedVersion().equals("1.4")) {
                                OpenMPI13xInputStream is = new OpenMPI13xInputStream(parserInputStream);
                                OpenMPIProcessMapXml13Parser.parse(is, new IOpenMPIProcessMapParserListener(){

                                    public void finish() {
                                        OpenMPIRuntimeSystemJob.this.getParserListener().disable();
                                    }

                                    public void finishMap(AttributeManager manager) {
                                        if (manager.getAttributes().length > 0) {
                                            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: updating model with display-map information", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID()});
                                            OpenMPIRuntimeSystemJob.this.getRtSystem().changeJob(OpenMPIRuntimeSystemJob.this.getJobID(), manager);
                                        }
                                        OpenMPIRuntimeSystemJob.this.setMapCompleted();
                                    }

                                    public void newProcess(OpenMPIProcessMap.Process proc) {
                                        OpenMPIRuntimeSystemJob.this.addProcess(job, proc);
                                    }

                                    public void start() {
                                    }

                                    public void stderr(OpenMPIProcessMap.Process proc, String output) {
                                        String stderr = output;
                                        if (configuration.getDetectedVersion().equals("1.3") && configuration.getServiceVersion() < 4) {
                                            stderr = String.valueOf(stderr) + "\n";
                                        }
                                        int index = 0;
                                        if (proc != null) {
                                            index = proc.getIndex();
                                        }
                                        StringAttribute attr = ProcessAttributes.getStderrAttributeDefinition().create(stderr);
                                        OpenMPIRuntimeSystemJob.this.setProcessAttribute(job, index, attr);
                                    }

                                    public void stdout(OpenMPIProcessMap.Process proc, String output) {
                                        String stdout = output;
                                        if (configuration.getDetectedVersion().equals("1.3") && configuration.getServiceVersion() < 4) {
                                            stdout = String.valueOf(stdout) + "\n";
                                        }
                                        int index = 0;
                                        if (proc != null) {
                                            index = proc.getIndex();
                                        }
                                        StringAttribute attr = ProcessAttributes.getStdoutAttributeDefinition().create(stdout);
                                        OpenMPIRuntimeSystemJob.this.setProcessAttribute(job, index, attr);
                                    }
                                });
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                        catch (Exception e) {
                            OpenMPIRuntimeSystemJob.this.parserException = e;
                            DebugUtil.error((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: {1}", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID(), e});
                            if (configuration.getDetectedVersion().equals("1.2")) {
                                OpenMPIRuntimeSystemJob.this.getParserListener().disable();
                            }
                            OpenMPIRuntimeSystemJob.this.setMapCompleted();
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (configuration.getDetectedVersion().equals("1.2")) {
                            OpenMPIRuntimeSystemJob.this.getParserListener().disable();
                        }
                        OpenMPIRuntimeSystemJob.this.setMapCompleted();
                        throw throwable;
                    }
                    if (configuration.getDetectedVersion().equals("1.2")) {
                        OpenMPIRuntimeSystemJob.this.getParserListener().disable();
                    }
                    OpenMPIRuntimeSystemJob.this.setMapCompleted();
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: display-map parser thread: finished", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID()});
            }
        };
    }

    protected void doBeforeExecution(IProgressMonitor monitor, IRemoteProcessBuilder builder) throws CoreException {
        IOpenMPIResourceManagerConfiguration configuration = (IOpenMPIResourceManagerConfiguration)this.getRtSystem().getRmConfiguration();
        if (configuration.getDetectedVersion().equals("1.3") && configuration.getServiceVersion() > 0 && configuration.getServiceVersion() < 3) {
            builder.redirectErrorStream(true);
        }
    }

    protected void doExecutionCleanUp(IProgressMonitor monitor) {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
            this.setProcess(null);
        }
        if (this.getStderrObserver() != null) {
            this.getStderrObserver().kill();
            this.setStderrObserver(null);
        }
        if (this.getStdoutObserver() != null) {
            this.getStdoutObserver().kill();
            this.setStdoutObserver(null);
        }
        this.terminateProcesses();
    }

    protected void doExecutionFinished(IProgressMonitor monitor) throws CoreException {
        this.terminateProcesses();
        if (this.getProcess().exitValue() != 0) {
            if (!this.terminateJobFlag) {
                this.changeJobStatusMessage(NLS.bind((String)Messages.OpenMPIRuntimeSystemJob_Exception_ExecutionFailedWithExitValue, (Object)new Integer(this.getProcess().exitValue())));
                this.changeJobStatus(MPIJobAttributes.Status.ERROR);
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING, (String)"RTS job #{0}: ignoring exit value {1} because job was forced to terminate by user", (Object[])new Object[]{this.getJobID(), new Integer(this.getProcess().exitValue())});
        } else if (this.errorDetected) {
            this.changeJobStatusMessage(NLS.bind((String)Messages.OpenMPIRuntimeSystemJob_Exception_ExecutionFailureDetected, (Object)this.errorMessage));
            this.changeJobStatus(MPIJobAttributes.Status.ERROR);
        }
    }

    protected void doExecutionStarted(IProgressMonitor monitor) throws CoreException {
        this.mapCompleted = false;
        IOpenMPIResourceManagerConfiguration configuration = (IOpenMPIResourceManagerConfiguration)this.getRtSystem().getRmConfiguration();
        final IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.getRtSystem().getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
        IntegerAttribute numProcsAttr = (IntegerAttribute)ipJob.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition());
        assert (numProcsAttr != null);
        this.getRtSystem().createProcesses(this.getJobID(), numProcsAttr.getValue().intValue());
        final BitSet procZero = new BitSet();
        if ((configuration.getDetectedVersion().equals("1.2") || configuration.getDetectedVersion().equals("1.3") && configuration.getServiceVersion() < 4) && ipJob.hasProcessByJobRank(0)) {
            procZero.set(0);
        }
        IInputStreamListener stdoutListener = new IInputStreamListener(){

            public void newBytes(byte[] bytes, int length) {
                String line = new String(bytes, 0, length);
                if (!OpenMPIRuntimeSystemJob.this.errorDetected && OpenMPIErrorParser.parse(line)) {
                    OpenMPIRuntimeSystemJob.this.errorDetected = true;
                    OpenMPIRuntimeSystemJob.this.errorMessage = OpenMPIErrorParser.getErrorMessage();
                }
                if (!procZero.isEmpty()) {
                    AttributeManager attributes = new AttributeManager((IAttribute)ProcessAttributes.getStdoutAttributeDefinition().create(line));
                    ((IPJobControl)ipJob).addProcessAttributes(procZero, attributes);
                }
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}: {1}", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID(), line});
            }

            public void streamClosed() {
            }

            public void streamError(Exception e) {
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stdout stream: {0}", (Object[])new Object[]{e});
                OpenMPIPlugin.log(e);
            }
        };
        IInputStreamListener stderrListener = new IInputStreamListener(){

            public void newBytes(byte[] bytes, int length) {
                String line = new String(bytes, 0, length);
                if (!OpenMPIRuntimeSystemJob.this.errorDetected && OpenMPIErrorParser.parse(line)) {
                    OpenMPIRuntimeSystemJob.this.errorDetected = true;
                    OpenMPIRuntimeSystemJob.this.errorMessage = OpenMPIErrorParser.getErrorMessage();
                }
                if (!procZero.isEmpty()) {
                    AttributeManager attributes = new AttributeManager((IAttribute)ProcessAttributes.getStderrAttributeDefinition().create(line));
                    ((IPJobControl)ipJob).addProcessAttributes(procZero, attributes);
                }
                DebugUtil.error((boolean)DebugUtil.RTS_JOB_OUTPUT_TRACING, (String)"RTS job #{0}: {1}", (Object[])new Object[]{OpenMPIRuntimeSystemJob.this.getJobID(), line});
            }

            public void streamClosed() {
            }

            public void streamError(Exception e) {
                DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: stderr stream: {0}", (Object[])new Object[]{e});
                OpenMPIPlugin.log(e);
            }
        };
        this.createParser(configuration, ipJob);
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: starting all threads", (Object[])new Object[]{this.getJobID()});
        this.getParser().start();
        this.setStderrObserver(new InputStreamObserver(this.getProcess().getErrorStream()));
        this.getStderrObserver().addListener(stderrListener);
        this.setStdoutObserver(new InputStreamObserver(this.getProcess().getInputStream()));
        this.getStdoutObserver().addListener(stdoutListener);
        if (configuration.getDetectedVersion().equals("1.2")) {
            if (!this.getRtSystem().getRemoteServices().getId().equals("org.eclipse.ptp.remote.RSERemoteServices")) {
                this.getStderrObserver().addListener((IInputStreamListener)this.getParserListener());
            } else {
                this.getStdoutObserver().addListener((IInputStreamListener)this.getParserListener());
            }
        } else if (configuration.getDetectedVersion().equals("1.3") || configuration.getDetectedVersion().equals("1.4")) {
            this.getStdoutObserver().addListener((IInputStreamListener)this.getParserListener());
        } else assert (false);
        this.getStderrObserver().start();
        this.getStdoutObserver().start();
        this.waitForMapCompleted();
        if (this.parserException != null) {
            if (!this.getProcess().isCompleted()) {
                this.getProcess().destroy();
            }
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.getJobID()});
            try {
                this.getStderrObserver().join();
            }
            catch (InterruptedException interruptedException) {}
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.getJobID()});
            try {
                this.getStdoutObserver().join();
            }
            catch (InterruptedException interruptedException) {}
            throw OpenMPIPlugin.coreErrorException("Failed to parse output of Open MPI command. Check output for errors.", this.parserException);
        }
    }

    protected void doPrepareExecution(IProgressMonitor monitor) throws CoreException {
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException {
        return null;
    }

    protected IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        int p = 0;
        String[] keys = new String[environment.size()];
        for (String key : environment.keySet()) {
            keys[p++] = key;
        }
        newAttributes.add(OpenMPILaunchAttributes.getEnvironmentKeysAttributeDefinition().create((Comparable[])keys));
        newAttributes.add(OpenMPILaunchAttributes.getEnvironmentArgsAttributeDefinition().create());
        return newAttributes.toArray(new IAttribute[newAttributes.size()]);
    }

    protected HashMap<String, String> doRetrieveToolEnvironment() throws CoreException {
        return null;
    }

    protected void doTerminateJob() {
    }

    protected void doWaitExecution(IProgressMonitor monitor) throws CoreException {
        try {
            DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting for display-map parser thread to finish", (Object[])new Object[]{this.getJobID()});
            this.parserThread.join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stderr thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.getStderrObserver().join();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting stdout thread to finish", (Object[])new Object[]{this.getJobID()});
        try {
            this.getStdoutObserver().join();
        }
        catch (InterruptedException interruptedException) {}
        if (this.parserException != null) {
            throw OpenMPIPlugin.coreErrorException("Failed to parse output of Open MPI command. Check output for errors.", this.parserException);
        }
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: waiting mpi process to finish completely", (Object[])new Object[]{this.getJobID()});
        try {
            this.getProcess().waitFor();
        }
        catch (InterruptedException interruptedException) {}
        DebugUtil.trace((boolean)DebugUtil.RTS_JOB_TRACING_MORE, (String)"RTS job #{0}: completely finished", (Object[])new Object[]{this.getJobID()});
    }

    protected Thread getParser() {
        return this.parserThread;
    }

    protected InputStreamListenerToOutputStream getParserListener() {
        return this.parserListener;
    }

    protected InputStreamObserver getStderrObserver() {
        return this.stderrObserver;
    }

    protected InputStreamObserver getStdoutObserver() {
        return this.stdoutObserver;
    }

    protected void setMapCompleted() {
        this.mapLock.lock();
        try {
            this.mapCompleted = true;
            this.mapCondition.signalAll();
        }
        finally {
            this.mapLock.unlock();
        }
    }

    protected void setParserListener(InputStreamListenerToOutputStream listener) {
        this.parserListener = listener;
    }

    protected void setStderrObserver(InputStreamObserver stderrObserver) {
        this.stderrObserver = stderrObserver;
    }

    protected void setStdoutObserver(InputStreamObserver stdoutObserver) {
        this.stdoutObserver = stdoutObserver;
    }

    /*
     * Exception decompiling
     */
    protected void waitForMapCompleted() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setProcessAttribute(IPJob job, int index, StringAttribute attr) {
        BitSet processIndices = new BitSet();
        processIndices.set(index);
        IPJobControl jobCtl = (IPJobControl)job;
        AttributeManager attrMgr = new AttributeManager((IAttribute)attr);
        jobCtl.addProcessAttributes(processIndices, attrMgr);
    }
}

