/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.control;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

class TargetControlledJob {
    protected static final int UNDEFINED = 0;
    protected static final int RUNNING = 1;
    protected static final int FINISHED = 2;
    JobRunner jobRunner;
    IRemoteExecutionManager executionManager;
    ITargetJob job;
    SSHTargetControl targetControl;
    int status = 0;

    public TargetControlledJob(SSHTargetControl controller, ITargetJob job) throws CoreException {
        this.targetControl = controller;
        this.job = job;
        try {
            this.executionManager = controller.createRemoteExecutionManager();
        }
        catch (RemoteConnectionException e) {
            CoreException ce = new CoreException((IStatus)new Status(4, EnvironmentPlugin.getUniqueIdentifier(), 0, e.getLocalizedMessage(), (Throwable)e));
            throw ce;
        }
        this.jobRunner = new JobRunner(this);
    }

    protected void start() {
        this.jobRunner.start();
    }

    public ITargetJob getJob() {
        return this.job;
    }

    public synchronized boolean isFinished() {
        return this.status == 2;
    }

    public synchronized void cancelExecution() {
        if (this.status != 2) {
            this.executionManager.cancel();
        }
    }

    protected class JobRunner
    extends Thread {
        private TargetControlledJob controller;

        protected JobRunner(TargetControlledJob controller) {
            this.controller = controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.controller.targetControl.notifyStartingJob(TargetControlledJob.this.job);
            TargetControlledJob targetControlledJob = this.controller;
            synchronized (targetControlledJob) {
                this.controller.status = 1;
            }
            try {
                TargetControlledJob.this.job.run(this.controller.executionManager);
            }
            catch (Throwable throwable) {
                TargetControlledJob targetControlledJob2 = this.controller;
                synchronized (targetControlledJob2) {
                    this.controller.status = 2;
                    this.controller.executionManager.close();
                    this.controller.targetControl.notifyFinishedJob(TargetControlledJob.this.job);
                }
                throw throwable;
            }
            TargetControlledJob targetControlledJob3 = this.controller;
            synchronized (targetControlledJob3) {
                this.controller.status = 2;
                this.controller.executionManager.close();
                this.controller.targetControl.notifyFinishedJob(TargetControlledJob.this.job);
            }
        }
    }
}

