/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.wizards;

import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.IToolRMConfiguration;
import org.eclipse.ptp.rm.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.wizards.AbstractConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class AbstractToolRMConfigurationWizardPage
extends AbstractConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private IRemoteServices remoteServices = null;
    private IRemoteConnection connection = null;
    protected Text launchCmdText = null;
    protected Text debugCmdText = null;
    protected Text discoverCmdText = null;
    protected Text continuousMonitorCmdText = null;
    protected Text periodicMonitorCmdText = null;
    protected Spinner periodicMonitorTimeSpinner = null;
    protected Text remoteInstallPathText = null;
    protected Button browseButton = null;
    protected Button defaultCmdButton = null;
    protected Button defaultInstallButton = null;
    protected boolean isEnabled;
    protected int capabilities = 0;

    public AbstractToolRMConfigurationWizardPage(IRMConfigurationWizard wizard, int capabilities, String pageName, String title, String description) {
        super(wizard, pageName);
        this.capabilities = capabilities;
        this.setTitle(title);
        this.setDescription(description);
    }

    public void updateControls() {
        boolean enabled = ((DataSource)this.getDataSource()).getCommandsEnabled();
        this.defaultCmdButton.setEnabled(enabled);
        if (enabled) {
            boolean bl = enabled = !this.defaultCmdButton.getSelection();
        }
        if (this.launchCmdText != null) {
            this.launchCmdText.setEnabled(enabled);
        }
        if (this.debugCmdText != null) {
            this.debugCmdText.setEnabled(enabled);
        }
        if (this.discoverCmdText != null) {
            this.discoverCmdText.setEnabled(enabled);
        }
        if (this.periodicMonitorCmdText != null) {
            this.periodicMonitorCmdText.setEnabled(enabled);
        }
        if (this.periodicMonitorTimeSpinner != null) {
            this.periodicMonitorTimeSpinner.setEnabled(enabled);
        }
        if (this.continuousMonitorCmdText != null) {
            this.continuousMonitorCmdText.setEnabled(enabled);
        }
        boolean bl = enabled = !this.defaultInstallButton.getSelection();
        if (this.remoteInstallPathText != null) {
            this.remoteInstallPathText.setEnabled(enabled);
        }
    }

    protected void createContents(Composite parent) {
        Label label;
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(4, false));
        contents.setLayoutData((Object)new GridData(768));
        Group cmdGroup = new Group(contents, 16);
        cmdGroup.setLayout((Layout)new GridLayout(4, false));
        cmdGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        cmdGroup.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_CommandGroup);
        this.defaultCmdButton = this.createCheckButton((Composite)cmdGroup, Messages.AbstractToolRMConfigurationWizardPage_Label_UseDefaultSettings);
        this.defaultCmdButton.addSelectionListener((SelectionListener)this.getWidgetListener());
        this.defaultCmdButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        if ((this.capabilities & 1) != 0) {
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_LaunchCommand);
            this.launchCmdText = new Text((Composite)cmdGroup, 2052);
            this.launchCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.launchCmdText.addModifyListener((ModifyListener)this.getWidgetListener());
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_DebugCommand);
            this.debugCmdText = new Text((Composite)cmdGroup, 2052);
            this.debugCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.debugCmdText.addModifyListener((ModifyListener)this.getWidgetListener());
        }
        if ((this.capabilities & 2) != 0) {
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_DiscoverCommand);
            this.discoverCmdText = new Text((Composite)cmdGroup, 2052);
            this.discoverCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.discoverCmdText.addModifyListener((ModifyListener)this.getWidgetListener());
        }
        if ((this.capabilities & 4) != 0) {
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_PeriodicMonitorCommand);
            this.periodicMonitorCmdText = new Text((Composite)cmdGroup, 2052);
            this.periodicMonitorCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.periodicMonitorCmdText.addModifyListener((ModifyListener)this.getWidgetListener());
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_PeriodicMonitorCommandPeriod);
            this.periodicMonitorTimeSpinner = new Spinner((Composite)cmdGroup, 2052);
            this.periodicMonitorTimeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.periodicMonitorTimeSpinner.addModifyListener((ModifyListener)this.getWidgetListener());
        }
        if ((this.capabilities & 8) != 0) {
            label = new Label((Composite)cmdGroup, 0);
            label.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_ContinuousMinitorCommand);
            this.continuousMonitorCmdText = new Text((Composite)cmdGroup, 2052);
            this.continuousMonitorCmdText.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            this.continuousMonitorCmdText.addModifyListener((ModifyListener)this.getWidgetListener());
        }
        if ((this.capabilities & 0x10) != 0) {
            Group pathGroup = new Group(contents, 16);
            pathGroup.setLayout((Layout)new GridLayout(4, false));
            pathGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            pathGroup.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_InstallationGroup);
            this.defaultInstallButton = this.createCheckButton((Composite)pathGroup, Messages.AbstractToolRMConfigurationWizardPage_Label_InstallationDefault);
            this.defaultInstallButton.addSelectionListener((SelectionListener)this.getWidgetListener());
            this.defaultInstallButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            Label label2 = new Label((Composite)pathGroup, 0);
            label2.setText(Messages.AbstractToolRMConfigurationWizardPage_Label_InstallationLocation);
            this.remoteInstallPathText = new Text((Composite)pathGroup, 2052);
            this.remoteInstallPathText.addModifyListener((ModifyListener)this.getWidgetListener());
            this.remoteInstallPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.browseButton = SWTUtil.createPushButton((Composite)pathGroup, (String)Messages.AbstractToolRMConfigurationWizardPage_Label_InstallationButton, null);
            this.browseButton.addSelectionListener((SelectionListener)this.getWidgetListener());
            this.browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        }
    }

    protected WizardPageDataSource createDataSource() {
        return new DataSource(this);
    }

    protected WizardPageWidgetListener createListener() {
        return new WidgetListener();
    }

    protected Composite doCreateContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        this.createContents(contents);
        return contents;
    }

    protected void handlePathBrowseButtonSelected() {
        IRemoteUIServices remUIServices = null;
        IRemoteResourceManagerConfiguration config = (IRemoteResourceManagerConfiguration)this.getDataSource().getConfig();
        String rmID = config.getRemoteServicesId();
        if (rmID != null) {
            this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(rmID);
            String conn = config.getConnectionName();
            if (this.remoteServices != null && conn != null) {
                this.connection = this.remoteServices.getConnectionManager().getConnection(conn);
            }
            remUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.remoteServices);
        }
        if (remUIServices != null && this.connection != null) {
            remUIServices.getUIConnectionManager().openConnectionWithProgress(this.getShell(), this.connection);
            if (this.connection.isOpen()) {
                IRemoteUIFileManager fileMgr = remUIServices.getUIFileManager();
                fileMgr.setConnection(this.connection);
                String initialPath = "//";
                String selectedPath = fileMgr.browseDirectory(this.getControl().getShell(), Messages.AbstractToolRMConfigurationWizardPage_Title_PathSelectionDialog, initialPath, 2);
                if (selectedPath != null) {
                    this.remoteInstallPathText.setText(selectedPath);
                }
            }
        }
    }

    protected class DataSource
    extends WizardPageDataSource {
        private IToolRMConfiguration config;
        private boolean commandsEnabled;
        private boolean useToolDefaults;
        private boolean useInstallDefaults;
        private String launchCmd;
        private String debugCmd;
        private String discoverCmd;
        private String periodicMonitorCmd;
        private int periodicMonitorTime;
        private String continuousMonitorCmd;
        private String remoteInstallPath;

        protected DataSource(AbstractConfigurationWizardPage page) {
            super(page);
            this.config = null;
            this.commandsEnabled = false;
            this.useToolDefaults = false;
            this.useInstallDefaults = false;
            this.launchCmd = null;
            this.debugCmd = null;
            this.discoverCmd = null;
            this.periodicMonitorCmd = null;
            this.periodicMonitorTime = 0;
            this.continuousMonitorCmd = null;
            this.remoteInstallPath = null;
        }

        public String getContinuousMonitorCmd() {
            return this.continuousMonitorCmd;
        }

        public String getDebugCmd() {
            return this.debugCmd;
        }

        public String getDiscoverCmd() {
            return this.discoverCmd;
        }

        public String getLaunchCmd() {
            return this.launchCmd;
        }

        public String getPeriodicMonitorCmd() {
            return this.periodicMonitorCmd;
        }

        public int getPeriodicMonitorTime() {
            return this.periodicMonitorTime;
        }

        public String getRemoteInstallPath() {
            return this.remoteInstallPath;
        }

        public boolean getCommandsEnabled() {
            return this.commandsEnabled;
        }

        public boolean getInstallDefaults() {
            return this.useInstallDefaults;
        }

        public boolean getUseDefaults() {
            return this.useToolDefaults;
        }

        public void setCommandFields(String launchCmd, String debugCmd, String discoverCmd, String periodicMonitorCmd, int periodicMonitorTime, String continuousMonitorCmd, String remoteInstallPath) {
            this.launchCmd = launchCmd;
            this.debugCmd = debugCmd;
            this.discoverCmd = discoverCmd;
            this.periodicMonitorCmd = periodicMonitorCmd;
            this.periodicMonitorTime = periodicMonitorTime;
            this.continuousMonitorCmd = continuousMonitorCmd;
            this.remoteInstallPath = remoteInstallPath;
        }

        public void setConfig(IResourceManagerConfiguration configuration) {
            super.setConfig(configuration);
            this.config = (IToolRMConfiguration)configuration;
        }

        public void setCommandsEnabled(boolean enable) {
            this.commandsEnabled = enable;
        }

        public void setInstallDefaults(boolean useInstallDefaults) {
            this.useInstallDefaults = useInstallDefaults;
        }

        public void setUseDefaults(boolean useToolDefaults) {
            this.useToolDefaults = useToolDefaults;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            this.useToolDefaults = AbstractToolRMConfigurationWizardPage.this.defaultCmdButton.getSelection();
            this.useInstallDefaults = AbstractToolRMConfigurationWizardPage.this.defaultInstallButton.getSelection();
            if (AbstractToolRMConfigurationWizardPage.this.launchCmdText != null) {
                this.launchCmd = this.extractText(AbstractToolRMConfigurationWizardPage.this.launchCmdText);
            }
            if (AbstractToolRMConfigurationWizardPage.this.debugCmdText != null) {
                this.debugCmd = this.extractText(AbstractToolRMConfigurationWizardPage.this.debugCmdText);
            }
            if (AbstractToolRMConfigurationWizardPage.this.discoverCmdText != null) {
                this.discoverCmd = this.extractText(AbstractToolRMConfigurationWizardPage.this.discoverCmdText);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText != null) {
                this.periodicMonitorCmd = this.extractText(AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner != null) {
                this.periodicMonitorTime = AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner.getSelection();
            }
            if (AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText != null) {
                this.continuousMonitorCmd = this.extractText(AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText);
            }
            if (AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText != null) {
                this.remoteInstallPath = this.extractText(AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText);
            }
        }

        protected void copyToFields() {
            if (AbstractToolRMConfigurationWizardPage.this.launchCmdText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.launchCmdText, this.launchCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.debugCmdText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.debugCmdText, this.debugCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.discoverCmdText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.discoverCmdText, this.discoverCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText, this.periodicMonitorCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner != null) {
                AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner.setSelection(this.periodicMonitorTime);
            }
            if (AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText, this.continuousMonitorCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText != null) {
                this.applyText(AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText, this.remoteInstallPath);
            }
            AbstractToolRMConfigurationWizardPage.this.defaultCmdButton.setSelection(this.useToolDefaults);
            AbstractToolRMConfigurationWizardPage.this.defaultInstallButton.setSelection(this.useInstallDefaults);
        }

        protected void copyToStorage() {
            if (AbstractToolRMConfigurationWizardPage.this.launchCmdText != null) {
                this.config.setLaunchCmd(this.launchCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.debugCmdText != null) {
                this.config.setDebugCmd(this.debugCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.discoverCmdText != null) {
                this.config.setDiscoverCmd(this.discoverCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText != null) {
                this.config.setPeriodicMonitorCmd(this.periodicMonitorCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner != null) {
                this.config.setPeriodicMonitorTime(this.periodicMonitorTime);
            }
            if (AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText != null) {
                this.config.setContinuousMonitorCmd(this.continuousMonitorCmd);
            }
            if (AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText != null) {
                this.config.setRemoteInstallPath(this.remoteInstallPath);
            }
            this.config.setUseToolDefaults(this.useToolDefaults);
            this.config.setUseInstallDefaults(this.useInstallDefaults);
            this.config.setCommandsEnabled(this.commandsEnabled);
        }

        protected void loadDefault() {
        }

        protected void loadFromStorage() {
            if (AbstractToolRMConfigurationWizardPage.this.launchCmdText != null) {
                this.launchCmd = this.config.getLaunchCmd();
            }
            if (AbstractToolRMConfigurationWizardPage.this.debugCmdText != null) {
                this.debugCmd = this.config.getDebugCmd();
            }
            if (AbstractToolRMConfigurationWizardPage.this.discoverCmdText != null) {
                this.discoverCmd = this.config.getDiscoverCmd();
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText != null) {
                this.periodicMonitorCmd = this.config.getPeriodicMonitorCmd();
            }
            if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner != null) {
                this.periodicMonitorTime = this.config.getPeriodicMonitorTime();
            }
            if (AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText != null) {
                this.continuousMonitorCmd = this.config.getContinuousMonitorCmd();
            }
            if (AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText != null) {
                this.remoteInstallPath = this.config.getRemoteInstallPath();
            }
            this.useToolDefaults = this.config.getUseToolDefaults();
            this.useInstallDefaults = this.config.getUseInstallDefaults();
            this.commandsEnabled = this.config.getCommandsEnabled();
        }

        protected void validateGlobal() throws DataSource.ValidationException {
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (!this.useToolDefaults) {
                if (AbstractToolRMConfigurationWizardPage.this.launchCmdText != null && this.launchCmd == null) {
                    throw new DataSource.ValidationException(Messages.AbstractToolRMConfigurationWizardPage_Validation_MissingLaunchCommand);
                }
                if (AbstractToolRMConfigurationWizardPage.this.debugCmdText != null && this.debugCmd == null) {
                    throw new DataSource.ValidationException(Messages.AbstractToolRMConfigurationWizardPage_Validation_MissingDebugCommand);
                }
                if (AbstractToolRMConfigurationWizardPage.this.discoverCmdText != null) {
                    if (this.discoverCmd == null) {
                        throw new DataSource.ValidationException(Messages.AbstractToolRMConfigurationWizardPage_Validation_MissingDiscoverCommand);
                    }
                    if (AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner != null && this.periodicMonitorTime < 1) {
                        throw new DataSource.ValidationException(Messages.AbstractToolRMConfigurationWizardPage_Validation_InvalidPeriodicMonitorCommandTimeRange);
                    }
                }
            }
        }
    }

    protected class WidgetListener
    extends WizardPageWidgetListener {
        protected WidgetListener() {
        }

        protected void doModifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (source == AbstractToolRMConfigurationWizardPage.this.launchCmdText || source == AbstractToolRMConfigurationWizardPage.this.debugCmdText || source == AbstractToolRMConfigurationWizardPage.this.discoverCmdText || source == AbstractToolRMConfigurationWizardPage.this.periodicMonitorCmdText || source == AbstractToolRMConfigurationWizardPage.this.continuousMonitorCmdText || source == AbstractToolRMConfigurationWizardPage.this.periodicMonitorTimeSpinner || source == AbstractToolRMConfigurationWizardPage.this.remoteInstallPathText) {
                AbstractToolRMConfigurationWizardPage.this.resetErrorMessages();
                AbstractToolRMConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else assert (false);
        }

        protected void doWidgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractToolRMConfigurationWizardPage.this.browseButton) {
                AbstractToolRMConfigurationWizardPage.this.handlePathBrowseButtonSelected();
            } else if (source == AbstractToolRMConfigurationWizardPage.this.defaultCmdButton || source == AbstractToolRMConfigurationWizardPage.this.defaultInstallButton) {
                AbstractToolRMConfigurationWizardPage.this.resetErrorMessages();
                AbstractToolRMConfigurationWizardPage.this.getDataSource().storeAndValidate();
                AbstractToolRMConfigurationWizardPage.this.updateControls();
            } else assert (false);
        }
    }
}

