/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteOperation;
import org.eclipse.ptp.remotetools.core.KeyAuthToken;
import org.eclipse.ptp.remotetools.core.PasswdAuthToken;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.common.RemoteTunnel;
import org.eclipse.ptp.remotetools.internal.core.ConnectionProperties;
import org.eclipse.ptp.remotetools.internal.ssh.CipherTypes;
import org.eclipse.ptp.remotetools.internal.ssh.ConnectionLocks;
import org.eclipse.ptp.remotetools.internal.ssh.ControlChannel;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionObserver;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.RemotePortForwardingPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
implements IRemoteConnection {
    private final IJSchService jsch = RemotetoolsPlugin.getDefault().getJSchService();
    private Session defaultSession;
    private String fUsername;
    private String fHostname;
    private int fPort;
    private int fTimeout;
    private String fCipherType;
    private final SSHUserInfo sshuserinfo = new SSHUserInfo();
    private IRemoteExecutionManager executionManager = null;
    private final Set<RemoteTunnel> tunnels = new HashSet<RemoteTunnel>();
    private static final int SFTP_POOLSIZE = 3;
    private final ArrayBlockingQueue<ChannelSftp> sftpChannelPool = new ArrayBlockingQueue(3);
    private final Hashtable<Integer, KillableExecution> activeProcessTable = new Hashtable();
    private int nextInternalPID;
    private ControlChannel controlChannel;
    private ExecutionObserver executionObserver;
    private final ArrayList<ConnectionSlot> connectionPool = new ArrayList();
    private final HashMap<Channel, ConnectionSlot> channelToConnectioPool = new HashMap();
    protected ConnectionLocks connectionLocks;
    private RemotePortForwardingPool forwardingPool;

    @Override
    public synchronized void connect(AuthToken authToken, String hostname, int port, String cipherType, int timeout, IProgressMonitor monitor) throws RemoteConnectionException {
        this.nextInternalPID = 0;
        this.fUsername = authToken.getUsername();
        if (authToken instanceof PasswdAuthToken) {
            this.sshuserinfo.setUsePassword(true);
            this.sshuserinfo.setPassword(((PasswdAuthToken)authToken).getPassword());
        } else if (authToken instanceof KeyAuthToken) {
            KeyAuthToken token = (KeyAuthToken)authToken;
            this.sshuserinfo.setUsePassword(false);
            this.sshuserinfo.setPassphrase(token.getPassphrase());
            try {
                this.jsch.getJSch().addIdentity(token.getKeyPath().getAbsolutePath());
            }
            catch (JSchException e) {
                throw new RemoteConnectionException(Messages.Connection_Connect_InvalidPrivateKey, e);
            }
        } else {
            throw new RuntimeException(Messages.Connection_AuthenticationTypeNotSupported);
        }
        this.fHostname = hostname;
        this.fPort = port;
        if (this.fPort == 0) {
            this.fPort = ConnectionProperties.defaultPort;
        }
        this.fCipherType = cipherType;
        if (this.fCipherType == null) {
            this.fCipherType = CipherTypes.CIPHER_DEFAULT;
        }
        this.fTimeout = timeout;
        if (this.fTimeout == 0) {
            this.fTimeout = ConnectionProperties.defaultTimeout;
        }
        try {
            this.defaultSession = this.jsch.createSession(this.fHostname, this.fPort, this.fUsername);
            this.sshuserinfo.reset();
            this.defaultSession.setUserInfo((UserInfo)this.sshuserinfo);
            this.defaultSession.setServerAliveInterval(300000);
            this.defaultSession.setServerAliveCountMax(6);
        }
        catch (JSchException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSession, e);
        }
        this.setSessionCipherType(this.defaultSession);
        try {
            this.defaultSession.connect(this.fTimeout);
        }
        catch (JSchException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedConnect, e);
        }
        catch (Exception e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedUnsupportedKeySize, e);
        }
        if (this.controlChannel == null) {
            this.controlChannel = new ControlChannel(this);
        }
        try {
            this.controlChannel.open(monitor);
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateControlChannel, e);
        }
        try {
            int i = 0;
            while (i < 3) {
                ChannelSftp sftp = (ChannelSftp)this.defaultSession.openChannel("sftp");
                sftp.connect();
                boolean bInterrupted = Thread.interrupted();
                while (sftp != null) {
                    try {
                        this.sftpChannelPool.put(sftp);
                        sftp = null;
                    }
                    catch (InterruptedException interruptedException) {
                        bInterrupted = true;
                    }
                }
                if (bInterrupted) {
                    Thread.currentThread().interrupt();
                }
                ++i;
            }
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSFTPConnection, e);
        }
        ConnectionSlot slot = new ConnectionSlot(this.defaultSession, ConnectionProperties.initialDefaultSessionLoad);
        this.connectionPool.add(slot);
        if (this.forwardingPool == null) {
            this.forwardingPool = new RemotePortForwardingPool(this);
        }
        if (this.executionManager != null) {
            this.executionManager.resetCancel();
        }
        this.executionObserver = new ExecutionObserver(this);
        this.executionObserver.start();
    }

    @Override
    public synchronized IRemoteExecutionManager createRemoteExecutionManager() throws RemoteConnectionException {
        if (this.executionManager == null) {
            this.executionManager = new ExecutionManager(this);
        }
        return this.executionManager;
    }

    @Override
    public synchronized void disconnect() {
        if (this.executionManager != null) {
            this.executionManager.close();
        }
        if (this.executionObserver != null) {
            this.executionObserver.cancel();
        }
        if (this.controlChannel != null) {
            this.controlChannel.close();
        }
        boolean bInterrupted = Thread.interrupted();
        while (!this.sftpChannelPool.isEmpty()) {
            try {
                this.sftpChannelPool.take().disconnect();
            }
            catch (InterruptedException interruptedException) {
                bInterrupted = true;
            }
        }
        this.sftpChannelPool.clear();
        if (bInterrupted) {
            Thread.currentThread().interrupt();
        }
        for (ConnectionSlot slot : this.connectionPool) {
            slot.session.disconnect();
        }
        this.connectionPool.clear();
        this.defaultSession = null;
        if (this.forwardingPool != null) {
            this.forwardingPool.disconnect();
        }
    }

    public String getHostname() {
        return this.fHostname;
    }

    public int getPort() {
        return this.fPort;
    }

    public Session getSession() {
        return this.defaultSession;
    }

    public ChannelSftp getSFTPChannel() throws RemoteConnectionException {
        try {
            ChannelSftp channel = null;
            boolean bInterrupted = Thread.interrupted();
            while (channel == null) {
                try {
                    channel = this.sftpChannelPool.take();
                }
                catch (InterruptedException interruptedException) {
                    bInterrupted = true;
                }
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (!channel.isConnected()) {
                channel = (ChannelSftp)this.defaultSession.openChannel("sftp");
                channel.connect();
            }
            return channel;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_Connect_FailedCreateSFTPConnection, e);
        }
    }

    public int getTimeout() {
        return this.fTimeout;
    }

    public String getUsername() {
        return this.fUsername;
    }

    @Override
    public synchronized boolean isConnected() {
        if (this.defaultSession == null) {
            return false;
        }
        try {
            this.test();
        }
        catch (RemoteConnectionException remoteConnectionException) {
            return false;
        }
        return this.defaultSession.isConnected();
    }

    public void releaseSFTPChannel(ChannelSftp channel) {
        boolean bInterrupted = Thread.interrupted();
        while (channel != null) {
            try {
                this.sftpChannelPool.put(channel);
                channel = null;
            }
            catch (InterruptedException interruptedException) {
                bInterrupted = true;
            }
        }
        if (bInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private ConnectionSlot createConnectionSlot() throws RemoteConnectionException {
        Session newSession = null;
        try {
            newSession = this.jsch.createSession(this.fHostname, this.fPort, this.fUsername);
            this.sshuserinfo.reset();
            newSession.setUserInfo((UserInfo)this.sshuserinfo);
            newSession.setServerAliveInterval(300000);
            newSession.setServerAliveCountMax(6);
            this.setSessionCipherType(newSession);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedCreateNewSession, e);
        }
        try {
            newSession.connect(this.fTimeout);
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateConnectionSlot_FailedConnectNewSession, e);
        }
        ConnectionSlot slot = new ConnectionSlot(newSession);
        this.connectionPool.add(slot);
        return slot;
    }

    private void setSessionCipherType(Session session) {
        if (!this.fCipherType.equals(CipherTypes.CIPHER_DEFAULT)) {
            if (!CipherTypes.getCipherTypesMap().containsKey(this.fCipherType)) {
                throw new RuntimeException(Messages.Connection_SetCipherType_CipherNotSupported);
            }
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("cipher.s2c", this.fCipherType);
            config.put("cipher.c2s", this.fCipherType);
            session.setConfig(config);
        }
    }

    protected ChannelExec createExecChannel(boolean isInConnectionPool) throws RemoteConnectionException {
        if (isInConnectionPool) {
            ChannelExec channel;
            ConnectionSlot suggestedSlot = null;
            for (ConnectionSlot slot : this.connectionPool) {
                if (slot.numberUsedChannels >= ConnectionProperties.maxChannelsPerConnection) continue;
                suggestedSlot = slot;
                break;
            }
            if (suggestedSlot == null) {
                suggestedSlot = this.createConnectionSlot();
            }
            try {
                channel = (ChannelExec)suggestedSlot.session.openChannel("exec");
            }
            catch (JSchException e) {
                throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
            }
            ++suggestedSlot.numberUsedChannels;
            this.channelToConnectioPool.put((Channel)channel, suggestedSlot);
            return channel;
        }
        try {
            return (ChannelExec)this.defaultSession.openChannel("exec");
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_CreateExecChannel_FailedCreateNewExecChannel, e);
        }
    }

    protected synchronized int createNextPIID() {
        return ++this.nextInternalPID % Integer.MAX_VALUE;
    }

    protected RemoteTunnel createTunnel(int localPort, String addressOnRemoteHost, int portOnRemoteHost) throws RemoteConnectionException, LocalPortBoundException {
        RemoteTunnel tunnel = new RemoteTunnel(localPort, portOnRemoteHost, addressOnRemoteHost);
        if (this.tunnels.contains(tunnel)) {
            throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
        }
        try {
            this.defaultSession.setPortForwardingL(tunnel.getLocalPort(), tunnel.getAddressOnRemoteHost(), tunnel.getPortOnRemoteHost());
        }
        catch (JSchException e) {
            if (e.getMessage().matches("PortForwardingL: local port .* is already registered.")) {
                throw new LocalPortBoundException(Messages.Connection_CreateTunnel_TunnelPortAlreadyAlloced);
            }
            throw new RemoteConnectionException(Messages.Connection_CreateTunnel_FailedCreateTunnel, e);
        }
        this.tunnels.add(tunnel);
        return tunnel;
    }

    protected Hashtable<Integer, KillableExecution> getActiveProcessTable() {
        return this.activeProcessTable;
    }

    protected RemotePortForwardingPool getForwardingPool() {
        return this.forwardingPool;
    }

    protected String getKillablePrefix(KillableExecution execution) {
        return this.controlChannel.getKillablePrefix(execution.getInternaID());
    }

    protected void killExecution(KillableExecution execution) {
        this.controlChannel.killRemoteProcess(execution.getPID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
            synchronized (hashtable) {
                this.getActiveProcessTable().put(new Integer(killableExecution.getInternaID()), killableExecution);
            }
        }
    }

    protected void releaseChannel(Channel channel) {
        channel.disconnect();
        ConnectionSlot slot = this.channelToConnectioPool.remove(channel);
        if (slot != null) {
            --slot.numberUsedChannels;
        }
    }

    protected void releaseTunnel(RemoteTunnel tunnel) throws RemoteConnectionException {
        if (!this.tunnels.contains(tunnel)) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_PortNotAllocedForTunnel);
        }
        try {
            RemoteTunnel remoteTunnel = tunnel;
            this.defaultSession.delPortForwardingL(remoteTunnel.getLocalPort());
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(Messages.Connection_ReleaseTunnel_FailedRemoveTunnel, e);
        }
        this.tunnels.remove(tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPID(int piid, int pid) {
        Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
        synchronized (hashtable) {
            KillableExecution exec = this.getActiveProcessTable().get(new Integer(piid));
            if (exec != null) {
                exec.setPID(pid);
            }
        }
    }

    protected synchronized void test() throws RemoteConnectionException {
        for (ConnectionSlot slot : this.connectionPool) {
            if (slot.session.isConnected()) continue;
            throw new RemoteConnectionException(Messages.Connection_0);
        }
        if (this.controlChannel == null || !this.controlChannel.isConnected()) {
            throw new RemoteConnectionException(Messages.Connection_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterObservedExecution(IRemoteOperation operation) {
        if (operation instanceof KillableExecution) {
            KillableExecution killableExecution = (KillableExecution)operation;
            Hashtable<Integer, KillableExecution> hashtable = this.getActiveProcessTable();
            synchronized (hashtable) {
                this.getActiveProcessTable().remove(new Integer(killableExecution.getInternaID()));
            }
        }
    }

    private class ConnectionSlot {
        Session session = null;
        int numberUsedChannels = 0;

        ConnectionSlot(Session session) {
            this.session = session;
        }

        ConnectionSlot(Session session, int initialLoad) {
            this.session = session;
            this.numberUsedChannels = initialLoad;
        }
    }

    private class SSHUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String password;
        private String passphrase;
        private boolean isPasswdBased;
        private boolean firstTry = true;

        private SSHUserInfo() {
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public String getPassword() {
            if (this.firstTry) {
                this.firstTry = false;
                return this.password;
            }
            return null;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (prompt.length != 1 || echo[0] || this.password == null) {
                return null;
            }
            String[] response = new String[]{this.password};
            if (this.firstTry) {
                this.firstTry = false;
                return response;
            }
            return null;
        }

        public boolean promptPassphrase(String message) {
            return !this.isPasswdBased;
        }

        public boolean promptPassword(String message) {
            return this.isPasswdBased;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public void reset() {
            this.firstTry = true;
        }

        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setUsePassword(boolean usePassword) {
            this.isPasswdBased = usePassword;
        }

        public void showMessage(String message) {
        }
    }
}

