/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteStatusTools;
import org.eclipse.ptp.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusTools
implements IRemoteStatusTools {
    private ExecutionManager manager;
    private UserInformation userInfoCache;
    private static int PASSWD_USERNAME_FIELD = 0;
    private static int PASSWD_USERID_FIELD = 2;
    private static int PASSWD_GROUPID_FIELD = 3;
    private static int PASSWD_HOMEDIR_FIELD = 5;
    private static int GROUP_GROUPID_FIELD = 2;
    private static int GROUP_USERLIST_FIELD = 3;

    protected StatusTools(ExecutionManager manager) {
        this.manager = manager;
    }

    @Override
    public Set<Integer> getRemotePortsInUse(int protocol) throws RemoteConnectionException, RemoteOperationException, CancelException {
        HashSet<Integer> portSet = new HashSet<Integer>();
        String protoStr = null;
        String protoStr6 = null;
        if (protocol == 1) {
            protoStr = "cat /proc/net/udp";
            protoStr6 = "cat /proc/net/udp6";
        } else if (protocol == 0) {
            protoStr = "cat /proc/net/tcp";
            protoStr6 = "cat /proc/net/tcp6";
        }
        try {
            IRemoteExecutionTools remExecTools = this.manager.getExecutionTools();
            String protoOutput = remExecTools.executeWithOutput(protoStr).replaceFirst("^\\p{Space}*sl.*inode\\p{Space}*\\n", "");
            String proto6Output = remExecTools.executeWithOutput(protoStr6).replaceFirst("^\\p{Space}*sl.*inode\\p{Space}*\\n", "");
            String rawProcOutput = protoOutput.concat(proto6Output);
            String[] rawProcLines = rawProcOutput.split("\n");
            int i = 0;
            while (i < rawProcLines.length) {
                String[] procFields = rawProcLines[i].trim().split(" ");
                String[] addrFields = procFields[1].split(":");
                String allocedPort = addrFields[1];
                portSet.add(Integer.valueOf(allocedPort, 16));
                ++i;
            }
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
        return portSet;
    }

    @Override
    public Set<Integer> getGroupIDSet() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.userInfoCache == null) {
            this.userInfoCache = this.fetchRemoteUserInfo();
        }
        return this.userInfoCache.getGroupIDSet();
    }

    private Set<Integer> getGroupIDSet_CatBased() throws RemoteConnectionException, RemoteOperationException, CancelException {
        String[] passwdFields = this.getPasswdFields();
        String username = passwdFields[PASSWD_USERNAME_FIELD].trim();
        String strPasswdGroupID = passwdFields[PASSWD_GROUPID_FIELD].trim();
        HashSet<Integer> groupIDSet = new HashSet<Integer>();
        if (!strPasswdGroupID.trim().equals("")) {
            groupIDSet.add(new Integer(Integer.parseInt(strPasswdGroupID)));
        }
        IRemoteExecutionTools remExecTools = this.manager.getExecutionTools();
        try {
            String rawGroup = remExecTools.executeWithOutput("cat /etc/group");
            String[] rawGroupLines = rawGroup.split("\\n");
            int i = 0;
            while (i < rawGroupLines.length) {
                String[] groupFields = rawGroupLines[i].split(":", -1);
                if (this.isUsernameInList(username, groupFields[GROUP_USERLIST_FIELD].split(","))) {
                    groupIDSet.add(new Integer(Integer.parseInt(groupFields[GROUP_GROUPID_FIELD].trim())));
                }
                ++i;
            }
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
        return groupIDSet;
    }

    private boolean isUsernameInList(String username, String[] usernameList) {
        int i = 0;
        while (i < usernameList.length) {
            if (usernameList[i].trim().equals(username)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getUserID() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.userInfoCache == null) {
            this.userInfoCache = this.fetchRemoteUserInfo();
        }
        return this.userInfoCache.getUserID();
    }

    public int getUserID_CatBased() throws RemoteConnectionException, RemoteOperationException, CancelException {
        String strUserID = this.getPasswdFields()[PASSWD_USERID_FIELD];
        return Integer.parseInt(strUserID);
    }

    private String[] getPasswdFields() throws RemoteOperationException, RemoteConnectionException, CancelException {
        String currentUsername = this.getUsername_WhoamiBased();
        IRemoteExecutionTools remExecTools = this.manager.getExecutionTools();
        try {
            String rawPasswd = remExecTools.executeWithOutput("cat /etc/passwd");
            String[] rawPasswdLines = rawPasswd.split("\\n");
            int i = 0;
            while (i < rawPasswdLines.length) {
                String[] passwdFields = rawPasswdLines[i].split(":", -1);
                if (passwdFields[PASSWD_USERNAME_FIELD].equals(currentUsername)) {
                    return passwdFields;
                }
                ++i;
            }
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
        throw new RuntimeException(Messages.RemoteStatusTools_GetPasswdFields_NoUsernameInPasswdFile);
    }

    @Override
    public String getUsername() throws RemoteConnectionException, RemoteOperationException, CancelException {
        if (this.userInfoCache == null) {
            this.userInfoCache = this.fetchRemoteUserInfo();
        }
        return this.userInfoCache.getUsername();
    }

    private String getUsername_WhoamiBased() throws RemoteConnectionException, RemoteOperationException, CancelException {
        try {
            IRemoteExecutionTools remExecTools = this.manager.getExecutionTools();
            String rawWhoAmI = remExecTools.executeWithOutput("whoami");
            return rawWhoAmI.trim();
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    private Set<Integer> readGroupList(String username) throws RemoteConnectionException, RemoteOperationException {
        HashSet<Integer> groupList = new HashSet<Integer>();
        BufferedReader etcGroupFile = null;
        try {
            try {
                IRemoteFileTools ft = this.manager.getRemoteFileTools();
                InputStream is = ft.getInputStream("/etc/group", null);
                etcGroupFile = new BufferedReader(new InputStreamReader(is));
                String line = etcGroupFile.readLine();
                while (line != null) {
                    String[] fields = line.split(":");
                    if (fields[0].trim().compareTo(username) == 0) {
                        groupList.add(new Integer(fields[2]));
                    } else if (fields.length == 4) {
                        String[] users = fields[3].split(",");
                        int i = 0;
                        while (i < users.length) {
                            if (users[i].trim().compareTo(username) == 0) {
                                groupList.add(new Integer(fields[2]));
                            }
                            ++i;
                        }
                    }
                    line = etcGroupFile.readLine();
                }
            }
            catch (IOException ioe) {
                throw new RemoteOperationException(ioe);
            }
            catch (CancelException ce) {
                throw new RemoteOperationException(ce);
            }
            catch (NumberFormatException nfe) {
                throw new RemoteOperationException(nfe);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new RemoteOperationException(aioobe);
            }
        }
        finally {
            try {
                if (etcGroupFile != null) {
                    etcGroupFile.close();
                }
            }
            catch (IOException ioe) {
                throw new RemoteOperationException(ioe);
            }
        }
        return groupList;
    }

    private UserInformation fetchRemoteUserInfo() throws RemoteConnectionException, RemoteOperationException, CancelException {
        try {
            Set<Integer> groupList;
            IRemoteExecutionTools remExecTools = this.manager.getExecutionTools();
            String rawUserInfo = remExecTools.executeWithOutput("echo `id -un`:`id -u`:`id -G`");
            String[] userInfoFields = rawUserInfo.trim().split(":", -1);
            if (userInfoFields[2].trim().equalsIgnoreCase("")) {
                groupList = this.readGroupList(userInfoFields[0]);
            } else {
                String[] groupFields = userInfoFields[2].split(" ", -1);
                groupList = new HashSet<Integer>();
                int i = 0;
                while (i < groupFields.length) {
                    groupList.add(new Integer(groupFields[i]));
                    ++i;
                }
            }
            return new UserInformation(new Integer(userInfoFields[1]), groupList, userInfoFields[0]);
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    @Override
    public long getTime() throws RemoteConnectionException, RemoteOperationException, CancelException {
        try {
            IRemoteExecutionTools execTools = this.manager.getExecutionTools();
            String rawData = execTools.executeWithOutput("date +'%s'");
            rawData = rawData.trim();
            return Long.parseLong(rawData) * 1000L;
        }
        catch (RemoteExecutionException e) {
            throw new RemoteOperationException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UserInformation {
        private Integer userID;
        private Set<Integer> groupIDSet;
        private String username;

        public UserInformation(Integer userID, Set<Integer> groupIDSet, String username) {
            this.userID = userID;
            this.groupIDSet = groupIDSet;
            this.username = username;
        }

        public Integer getUserID() {
            return this.userID;
        }

        public Set<Integer> getGroupIDSet() {
            return this.groupIDSet;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

