/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.core.rmsystem;

import java.util.BitSet;
import java.util.Collection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.rm.slurm.core.SLURMJobAttributes;
import org.eclipse.ptp.rm.slurm.core.SLURMNodeAttributes;
import org.eclipse.ptp.rm.slurm.core.messages.Messages;
import org.eclipse.ptp.rm.slurm.core.rmsystem.ISLURMResourceManagerConfiguration;
import org.eclipse.ptp.rm.slurm.core.rtsystem.SLURMProxyRuntimeClient;
import org.eclipse.ptp.rm.slurm.core.rtsystem.SLURMRuntimeSystem;
import org.eclipse.ptp.rmsystem.AbstractRuntimeResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rtsystem.IRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeSubmitJobErrorEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLURMResourceManager
extends AbstractRuntimeResourceManager {
    private Integer SLURMRMID;

    public SLURMResourceManager(Integer id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id.toString(), universe, config);
        this.SLURMRMID = id;
    }

    protected void doAfterCloseConnection() {
    }

    protected void doAfterOpenConnection() {
    }

    protected void doBeforeCloseConnection() {
    }

    protected void doBeforeOpenConnection() {
    }

    protected IPJobControl doCreateJob(IPQueueControl queue, String jobId, AttributeManager attrs) {
        return this.newJob(queue, jobId, attrs);
    }

    protected IPMachineControl doCreateMachine(String machineId, AttributeManager attrs) {
        return this.newMachine(machineId, attrs);
    }

    protected IPNodeControl doCreateNode(IPMachineControl machine, String nodeId, AttributeManager attrs) {
        return this.newNode(machine, nodeId, attrs);
    }

    protected IPQueueControl doCreateQueue(String queueId, AttributeManager attrs) {
        return this.newQueue(queueId, attrs);
    }

    protected IRuntimeSystem doCreateRuntimeSystem() {
        ISLURMResourceManagerConfiguration config = (ISLURMResourceManagerConfiguration)this.getConfiguration();
        SLURMProxyRuntimeClient runtimeProxy = new SLURMProxyRuntimeClient(config, this.SLURMRMID);
        AttributeDefinitionManager attrDefMgr = this.getAttributeDefinitionManager();
        attrDefMgr.setAttributeDefinitions(SLURMJobAttributes.getDefaultAttributeDefinitions());
        attrDefMgr.setAttributeDefinitions(SLURMNodeAttributes.getDefaultAttributeDefinitions());
        SLURMRuntimeSystem slurmRMS = new SLURMRuntimeSystem(runtimeProxy, attrDefMgr);
        return slurmRMS;
    }

    protected boolean doUpdateJobs(IPQueueControl queue, Collection<IPJobControl> jobs, AttributeManager attrs) {
        return this.updateJobs(queue, jobs, attrs);
    }

    protected boolean doUpdateMachines(Collection<IPMachineControl> machines, AttributeManager attrs) {
        return this.updateMachines(machines, attrs);
    }

    protected boolean doUpdateNodes(IPMachineControl machine, Collection<IPNodeControl> nodes, AttributeManager attrs) {
        return this.updateNodes(machine, nodes, attrs);
    }

    protected boolean doUpdateProcesses(IPJobControl job, BitSet processJobRanks, AttributeManager attrs) {
        return this.updateProcessesByJobRanks(job, processJobRanks, attrs);
    }

    protected boolean doUpdateQueues(Collection<IPQueueControl> queues, AttributeManager attrs) {
        return this.updateQueues(queues, attrs);
    }

    protected boolean doUpdateRM(AttributeManager attrs) {
        return this.updateRM(attrs);
    }

    public void handleEvent(IRuntimeSubmitJobErrorEvent e) {
        final String title = Messages.SLURMResourceManager_0;
        final String msg = e.getErrorMessage();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        });
    }
}

