/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WorkingDirectoryBlock
extends LaunchConfigurationTab {
    protected Button useDefaultWorkingDirButton = null;
    protected Text workingDirText = null;
    protected Button workingDirBrowseButton = null;
    protected ILaunchConfiguration launchConfiguration;
    protected WidgetListener listener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite workingDirComp = new Composite(parent, 0);
        workingDirComp.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        workingDirComp.setLayoutData((Object)this.spanGridData(768, 5));
        this.setControl((Control)workingDirComp);
        Label workingDirLabel = new Label(workingDirComp, 0);
        workingDirLabel.setText(Messages.WorkingDirectoryBlock_Working_directory_colon);
        workingDirLabel.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton = new Button(workingDirComp, 32);
        this.useDefaultWorkingDirButton.setText(Messages.WorkingDirectoryBlock_Use_default_working_directory);
        this.useDefaultWorkingDirButton.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton.addSelectionListener((SelectionListener)this.listener);
        Label dirLabel = new Label(workingDirComp, 0);
        dirLabel.setText(Messages.WorkingDirectoryBlock_Local_directory);
        this.workingDirText = new Text(workingDirComp, 2052);
        this.workingDirText.setLayoutData((Object)new GridData(768));
        this.workingDirText.addModifyListener((ModifyListener)this.listener);
        this.workingDirBrowseButton = this.createPushButton(workingDirComp, Messages.Tab_common_Browse_1, null);
        this.workingDirBrowseButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
            this.workingDirText.setText("");
            if (wd == null) {
                this.useDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(wd);
                if (path.isAbsolute()) {
                    this.workingDirText.setText(wd);
                }
                this.useDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.CommonTab_common_Exception_occurred_reading_configuration_EXCEPTION);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            wd = this.getFieldContent(this.workingDirText.getText());
        }
        configuration.setAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", wd);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String workingDirPath;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isDefaultWorkingDirectory() && (workingDirPath = this.getFieldContent(this.workingDirText.getText())) == null) {
            this.setErrorMessage(Messages.WorkingDirectoryBlock_7);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.WorkingDirectoryBlock_Working_directory;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.useDefaultWorkingDirButton.getSelection();
    }

    protected void setDefaultWorkingDir(ILaunchConfiguration configuration) {
        if (configuration == null) {
            this.workingDirText.setText(System.getProperty("user.dir"));
            return;
        }
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        if (this.isDefaultWorkingDirectory()) {
            this.setDefaultWorkingDir(this.getLaunchConfiguration());
            this.workingDirText.setEnabled(false);
            this.workingDirBrowseButton.setEnabled(false);
        } else {
            this.workingDirText.setEnabled(true);
            this.workingDirBrowseButton.setEnabled(true);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(this.getLaunchConfiguration());
        if (rm != null) {
            IResourceManagerConfiguration conf = rm.getConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId());
            if (remoteServices != null) {
                IRemoteUIServices remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(remoteServices);
                if (remoteUIServices != null) {
                    IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
                    if (connMgr != null) {
                        IRemoteConnection conn = connMgr.getConnection(conf.getConnectionName());
                        if (conn != null) {
                            IRemoteUIFileManager fileManager = remoteUIServices.getUIFileManager();
                            if (fileManager != null) {
                                fileManager.setConnection(conn);
                                fileManager.showConnections(false);
                                String path = fileManager.browseDirectory(this.getShell(), Messages.WorkingDirectoryBlock_0, this.getFieldContent(this.workingDirText.getText()), 0);
                                if (path != null) {
                                    this.workingDirText.setText(path.toString());
                                }
                            } else {
                                this.setErrorMessage(Messages.WorkingDirectoryBlock_1);
                            }
                        } else {
                            this.setErrorMessage(Messages.WorkingDirectoryBlock_2);
                        }
                    } else {
                        this.setErrorMessage(Messages.WorkingDirectoryBlock_3);
                    }
                } else {
                    this.setErrorMessage(Messages.WorkingDirectoryBlock_4);
                }
            } else {
                this.setErrorMessage(Messages.WorkingDirectoryBlock_5);
            }
        } else {
            this.setErrorMessage(Messages.WorkingDirectoryBlock_6);
        }
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.useDefaultWorkingDirButton) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.workingDirBrowseButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent evt) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }
    }
}

