/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerServiceProvider;
import org.eclipse.ptp.rm.pbs.core.PBSPreferenceManager;
import org.eclipse.ptp.rm.pbs.core.rmsystem.IPBSResourceManagerConfiguration;
import org.eclipse.ptp.rm.pbs.core.rmsystem.PBSResourceManager;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class PBSServiceProvider
extends AbstractRemoteResourceManagerServiceProvider
implements IPBSResourceManagerConfiguration {
    private final Preferences preferences = PBSPreferenceManager.getPreferences();

    public PBSServiceProvider() {
        this.setDescription(Messages.PBSResourceManager);
    }

    public PBSServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new PBSServiceProvider((IServiceProvider)this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new PBSResourceManager(Integer.valueOf(universe.getNextResourceManagerId()), universe, (IResourceManagerConfiguration)this);
    }

    public String getDefaultTemplateName() {
        return this.getString(String.valueOf(this.getResourceManagerId()) + Messages.PBSServiceProvider_defaultTemplateName, "");
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public boolean isConfigured() {
        return true;
    }

    public void setDefaultNameAndDesc() {
        String name = "PBS";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription(Messages.PBSResourceManager);
    }

    public void setDefaultTemplateName(String name) {
        this.putString(String.valueOf(this.getResourceManagerId()) + Messages.PBSServiceProvider_defaultTemplateName, name);
    }
}

