/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.rm.pbs.ui.data.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    public static final String EMPTY_STRING = "";
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static String REMOTE_LINE_SEP = "\n";
    public static String REMOTE_PATH_SEP = "/";

    private ConfigUtils() {
    }

    public static AttributePlaceholder getAttributePlaceholder(String key, String value, String toolTip, Map<String, IAttributeDefinition<?, ?, ?>> defs) throws IllegalValueException {
        AttributePlaceholder ap = new AttributePlaceholder();
        ap.setName(key);
        if (!EMPTY_STRING.equals(toolTip)) {
            ap.setToolTip(toolTip);
        }
        if (defs != null) {
            IAttributeDefinition<?, ?, ?> def = defs.get(key);
            if (def == null) {
                throw new IllegalValueException(String.valueOf(Messages.PBSAttributeNotFound) + key);
            }
            IAttribute attr = def.create();
            ap.setAttribute(attr);
            String defaultValue = attr.getValueAsString();
            ap.setDefaultString(defaultValue);
            if (value != null && (!EMPTY_STRING.equals(value) || attr instanceof StringAttribute && !EMPTY_STRING.equals(defaultValue))) {
                attr.setValueAsString(value);
            }
        }
        return ap;
    }

    public static void setREMOTE_LINE_SEP(String rEMOTE_LINE_SEP) {
        REMOTE_LINE_SEP = rEMOTE_LINE_SEP;
    }

    public static void setREMOTE_PATH_SEP(String rEMOTE_PATH_SEP) {
        REMOTE_PATH_SEP = rEMOTE_PATH_SEP;
    }

    public static class PrefixFilter
    implements FilenameFilter {
        private final String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix);
        }
    }

    public static class SuffixFilter
    implements FilenameFilter {
        private final String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.suffix);
        }
    }
}

