/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.IRemoteFastIndexerListener;
import org.eclipse.ptp.internal.rdt.core.index.IRemoteFastIndexerUpdateEvent;
import org.eclipse.ptp.internal.rdt.core.index.IndexBuildSequenceController;
import org.eclipse.ptp.internal.rdt.core.index.RemoteFastIndexer;
import org.eclipse.ptp.internal.rdt.core.index.RemoteFastIndexerUpdateEvent;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerProgress;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;

public class RemoteIndexerTask
implements IPDOMIndexerTask {
    protected RemoteFastIndexer fIndexer;
    protected IIndexServiceProvider fIndexServiceProvider;
    protected ITranslationUnit[] fAdded;
    protected ITranslationUnit[] fChanged;
    protected ITranslationUnit[] fRemoved;
    protected boolean fUpdate;
    private RemoteIndexerProgress fRemoteProgress = new RemoteIndexerProgress();

    public RemoteIndexerTask(RemoteFastIndexer indexer, IIndexServiceProvider indexingServiceProvider, ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed, boolean update) {
        this.fIndexer = indexer;
        this.fIndexServiceProvider = indexingServiceProvider;
        this.fAdded = added;
        this.fChanged = changed;
        this.fRemoved = removed;
        this.fUpdate = update;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexerProgress getProgressInformation() {
        RemoteIndexerProgress remoteIndexerProgress = this.fRemoteProgress;
        synchronized (remoteIndexerProgress) {
            return RemoteIndexerProgress.getIndexerProgress(this.fRemoteProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgressInformation(RemoteIndexerProgress progress) {
        RemoteIndexerProgress remoteIndexerProgress = this.fRemoteProgress;
        synchronized (remoteIndexerProgress) {
            if (progress != null) {
                this.fRemoteProgress = progress;
            }
        }
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        IIndexLifecycleService service = this.fIndexServiceProvider.getIndexLifeCycleService();
        IProject project = this.fIndexer.getProject().getProject();
        Scope scope = new Scope(project);
        IndexBuildSequenceController projectStatus = IndexBuildSequenceController.getIndexBuildSequenceController(this.fIndexer.getProject().getProject());
        if (this.fUpdate) {
            for (IRemoteFastIndexerListener listener : RemoteFastIndexer.getRemoteFastIndexerListeners()) {
                listener.indexerUpdating(new RemoteFastIndexerUpdateEvent(IRemoteFastIndexerUpdateEvent.EventType.EVENT_UPDATE, this, scope));
            }
            service.update(scope, Arrays.asList(this.fAdded), Arrays.asList(this.fChanged), Arrays.asList(this.fRemoved), monitor, this);
        } else {
            for (IRemoteFastIndexerListener listener : RemoteFastIndexer.getRemoteFastIndexerListeners()) {
                listener.indexerUpdating(new RemoteFastIndexerUpdateEvent(IRemoteFastIndexerUpdateEvent.EventType.EVENT_REINDEX, this, scope));
            }
            service.reindex(scope, this.fIndexServiceProvider.getIndexLocation(), Arrays.asList(this.fAdded), monitor, this);
        }
        projectStatus.setIndexCompleted();
    }
}

