/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.cdt.internal.core.indexer.IStandaloneScannerInfoProvider;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkageFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLanguageMapper;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLocationConverter;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLogService;
import org.eclipse.ptp.internal.rdt.core.miners.ScopeManager;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

public class RemoteIndexManager {
    public static final String PDOM_EXTENSION = ".pdom";
    private static final String CLASS_NAME = "CDTMiner-RemoteIndexManager";
    private static RemoteIndexManager theInstance = null;
    private static final PDOMCLinkageFactory cLinkageFactory = new PDOMCLinkageFactory();
    private static final PDOMCPPLinkageFactory cppLinkageFactory = new PDOMCPPLinkageFactory();
    private static final IIndexLocationConverter locationConverter = new RemoteLocationConverter();
    private static final Map<String, IPDOMLinkageFactory> linkageFactoryMap = new HashMap<String, IPDOMLinkageFactory>();
    private final Map<String, StandaloneIndexer> scopeToIndexerMap = new HashMap<String, StandaloneIndexer>();
    private final Map<String, String> scopeToIndexLocationMap = new HashMap<String, String>();

    static {
        linkageFactoryMap.put("C", (IPDOMLinkageFactory)cLinkageFactory);
        linkageFactoryMap.put("C++", (IPDOMLinkageFactory)cppLinkageFactory);
    }

    private RemoteIndexManager() {
    }

    public static synchronized RemoteIndexManager getInstance() {
        if (theInstance == null) {
            theInstance = new RemoteIndexManager();
        }
        return theInstance;
    }

    public IIndex getIndexForScope(String scope, DataStore dataStore) {
        if (scope.equals("__WORKSPACE_ROOT_SCOPE__")) {
            HashSet<IWritableIndexFragment> fragments = new HashSet<IWritableIndexFragment>();
            for (String currentScope : ScopeManager.getInstance().getAllScopes()) {
                IWritableIndexFragment fragment = this.getIndexerForScope(currentScope, dataStore, null).getIndex().getWritableFragment();
                fragments.add(fragment);
            }
            if (fragments.isEmpty()) {
                UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)"Index contains 0 fragments", (DataStore)dataStore);
            }
            return new CIndex(fragments.toArray(new IIndexFragment[fragments.size()]), fragments.size());
        }
        StandaloneFastIndexer indexer = this.getIndexerForScope(scope, dataStore, null);
        return indexer.getIndex();
    }

    public StandaloneFastIndexer getIndexerForScope(String scope, IRemoteIndexerInfoProvider provider, DataStore dataStore, DataElement status) {
        StandaloneFastIndexer indexer = this.getIndexerForScope(scope, dataStore, status);
        indexer.setScannerInfoProvider((IStandaloneScannerInfoProvider)provider);
        indexer.setLanguageMapper((ILanguageMapper)new RemoteLanguageMapper(provider, dataStore));
        indexer.setFilesToParseUpFront(provider.getFilesToParseUpFront().toArray(new String[0]));
        indexer.setFileEncodingRegistry(provider.getFileEncodingRegistry());
        if (provider.checkIndexerPreference("skipReferences")) {
            indexer.setSkipReferences(PDOMWriter.SKIP_ALL_REFERENCES);
        } else {
            int skipReferences = 0;
            if (provider.checkIndexerPreference("skipTypeReferences")) {
                skipReferences |= PDOMWriter.SKIP_TYPE_REFERENCES;
            }
            if (provider.checkIndexerPreference("updatePolicy")) {
                skipReferences |= PDOMWriter.SKIP_MACRO_REFERENCES;
            }
            if (skipReferences == 0) {
                indexer.setSkipReferences(PDOMWriter.SKIP_NO_REFERENCES);
            } else {
                indexer.setSkipReferences(skipReferences);
            }
        }
        indexer.setIndexAllFiles(provider.checkIndexerPreference("indexAllFiles"));
        return indexer;
    }

    private boolean createIndexDirectory(String path) {
        if (path == null) {
            return false;
        }
        File dir = new File(path);
        if (dir.exists()) {
            return dir.canWrite();
        }
        return dir.mkdirs();
    }

    public StandaloneFastIndexer getIndexerForScope(String scope, DataStore dataStore, DataElement status) {
        if (scope.equals("__WORKSPACE_ROOT_SCOPE__")) {
            throw new IllegalArgumentException("Attempted to get indexer for root scope.");
        }
        StandaloneFastIndexer indexer = (StandaloneFastIndexer)this.scopeToIndexerMap.get(scope);
        if (indexer != null) {
            if (status != null) {
                RemoteLogService LOG = new RemoteLogService(dataStore, status);
                indexer.setParserLog((IParserLogService)LOG);
            }
            return indexer;
        }
        String path = this.scopeToIndexLocationMap.get(scope);
        File indexFile = null;
        if (path != null) {
            indexFile = new File(path, String.valueOf(scope) + PDOM_EXTENSION);
            try {
                if (!indexFile.exists() && !indexFile.createNewFile()) {
                    indexFile = null;
                }
            }
            catch (IOException iOException) {
                indexFile = null;
            }
        }
        if (indexFile == null) {
            indexFile = new File(String.valueOf(scope) + PDOM_EXTENSION);
            UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)("Can't create index file at " + path + " attempting to use " + indexFile.getParent() + " instead"), (DataStore)dataStore);
            this.scopeToIndexLocationMap.put(scope, indexFile.getParent());
        }
        UniversalServerUtilities.logInfo((String)CLASS_NAME, (String)("Index at location:" + indexFile.getAbsolutePath()), (DataStore)dataStore);
        try {
            RemoteLogService LOG = new RemoteLogService(dataStore, status);
            indexer = new StandaloneFastIndexer(indexFile, locationConverter, linkageFactoryMap, null, null, (IParserLogService)LOG);
            this.scopeToIndexerMap.put(scope, (StandaloneIndexer)indexer);
        }
        catch (CoreException e) {
            UniversalServerUtilities.logError((String)CLASS_NAME, (String)"Core Exception while getting indexer for scope", (Throwable)e, (DataStore)dataStore);
        }
        return indexer;
    }

    public boolean removeIndexFile(String scope, DataStore dataStore) {
        if (scope.equals("__WORKSPACE_ROOT_SCOPE__")) {
            throw new IllegalArgumentException("Attempted to remove index file for root scope.");
        }
        this.scopeToIndexerMap.remove(scope);
        String loc = this.scopeToIndexLocationMap.remove(scope);
        File indexFile = loc == null ? new File(String.valueOf(scope) + PDOM_EXTENSION) : new File(loc, String.valueOf(scope) + PDOM_EXTENSION);
        UniversalServerUtilities.logInfo((String)CLASS_NAME, (String)("Remove index at location: " + indexFile.getAbsolutePath()), (DataStore)dataStore);
        return indexFile.delete();
    }

    public IIndex getIndexForProjects(ICProject[] projects, DataStore dataStore) {
        if (projects == null) {
            throw new IllegalArgumentException("Get index for projects - projects cannot be null.");
        }
        HashSet<IWritableIndexFragment> fragments = new HashSet<IWritableIndexFragment>();
        Set<String> allScopes = ScopeManager.getInstance().getAllScopes();
        int i = 0;
        while (i < projects.length) {
            String currentScope = projects[i].getElementName();
            if (allScopes.contains(currentScope)) {
                IWritableIndexFragment fragment = this.getIndexerForScope(currentScope, dataStore, null).getIndex().getWritableFragment();
                fragments.add(fragment);
            }
            ++i;
        }
        CIndex index = new CIndex(fragments.toArray(new IIndexFragment[fragments.size()]), fragments.size());
        return index;
    }

    public String setIndexFileLocation(String scope, String configLocation) {
        String oldLocation = this.scopeToIndexLocationMap.get(scope);
        if (configLocation.equals(oldLocation)) {
            return configLocation;
        }
        this.scopeToIndexerMap.remove(scope);
        if (this.createIndexDirectory(configLocation)) {
            this.scopeToIndexLocationMap.put(scope, configLocation);
            return configLocation;
        }
        String serverDir = System.getProperty("user.dir");
        this.scopeToIndexLocationMap.put(scope, serverDir);
        return serverDir;
    }

    public String moveIndexFile(String scope, String path, DataStore dataStore) {
        String oldLocation = this.scopeToIndexLocationMap.get(scope);
        String newLocation = this.setIndexFileLocation(scope, path);
        if (!newLocation.equals(path)) {
            UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)("Can't move index file to " + path + " using " + newLocation + " instead"), (DataStore)dataStore);
        }
        if (newLocation.equals(oldLocation)) {
            UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)"Index file not moved because source and destination are the same", (DataStore)dataStore);
            return oldLocation;
        }
        UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)("Moving index file " + scope + PDOM_EXTENSION + " from " + oldLocation + " to " + newLocation), (DataStore)dataStore);
        String fileName = String.valueOf(scope) + PDOM_EXTENSION;
        File pdomFile = new File(oldLocation, fileName);
        if (!pdomFile.exists()) {
            UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)("Can't find index file at " + oldLocation), (DataStore)dataStore);
            return oldLocation;
        }
        boolean success = pdomFile.renameTo(new File(newLocation, fileName));
        if (success) {
            UniversalServerUtilities.logInfo((String)CLASS_NAME, (String)("Index file moved from " + oldLocation + " to " + newLocation), (DataStore)dataStore);
            return newLocation;
        }
        UniversalServerUtilities.logWarning((String)CLASS_NAME, (String)"Index file could not be moved", (DataStore)dataStore);
        return oldLocation;
    }
}

