/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.core.remotemake;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ScannerInfoUtility {
    public static ConsoleOutputSniffer createBuildOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, IConfiguration cfg, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        ICfgScannerConfigBuilderInfo2Set container = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg);
        Map map = container.getInfoMap();
        ArrayList clParserList = new ArrayList();
        if (container.isPerRcTypeDiscovery()) {
            IResourceInfo[] rcInfos = cfg.getResourceInfos();
            int q = 0;
            while (q < rcInfos.length) {
                IResourceInfo rcInfo = rcInfos[q];
                ITool[] tools = rcInfo instanceof IFileInfo ? ((IFileInfo)rcInfo).getToolsToInvoke() : ((IFolderInfo)rcInfo).getFilteredTools();
                int i = 0;
                while (i < tools.length) {
                    ITool tool = tools[i];
                    IInputType[] types = tool.getInputTypes();
                    if (types.length != 0) {
                        int k = 0;
                        while (k < types.length) {
                            IInputType type = types[k];
                            CfgInfoContext c = new CfgInfoContext(rcInfo, tool, type);
                            ScannerInfoUtility.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                            ++k;
                        }
                    } else {
                        CfgInfoContext c = new CfgInfoContext(rcInfo, tool, null);
                        ScannerInfoUtility.contributeToConsoleParserList(project, map, c, workingDirectory, markerGenerator, collector, clParserList);
                    }
                    ++i;
                }
                ++q;
            }
        }
        if (clParserList.size() == 0) {
            ScannerInfoUtility.contributeToConsoleParserList(project, map, new CfgInfoContext(cfg), workingDirectory, markerGenerator, collector, clParserList);
        }
        if (clParserList.size() != 0) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])clParserList.toArray(new IScannerInfoConsoleParser[clParserList.size()]));
        }
        return null;
    }

    public static boolean contributeToConsoleParserList(IProject project, Map map, CfgInfoContext context, IPath workingDirectory, IMarkerGenerator markerGenerator, IScannerInfoCollector collector, List parserList) {
        IScannerConfigBuilderInfo2 info = (IScannerConfigBuilderInfo2)map.get(context);
        InfoContext ic = context.toInfoContext();
        boolean added = false;
        if (info != null && info.isAutoDiscoveryEnabled() && info.isBuildOutputParserEnabled()) {
            HashSet<String> profileIDSet = new HashSet<String>();
            ITool tool = context.getTool();
            if (tool != null) {
                IInputType[] inputTypes;
                IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
                int n = inputTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] profileIDs;
                    IInputType inputType = iInputTypeArray[n2];
                    InputType realInputType = (InputType)inputType;
                    String profileIDString = realInputType.getDiscoveryProfileIdAttribute();
                    String[] stringArray = profileIDs = profileIDString.split("\\|");
                    int n3 = profileIDs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String profileID = stringArray[n4];
                        profileIDSet.add(profileID);
                        ++n4;
                    }
                    ++n2;
                }
            }
            for (String id : profileIDSet) {
                ScannerConfigProfile profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(id);
                if (profile.getBuildOutputProviderElement() == null) continue;
                SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, ic, id);
                IScannerInfoConsoleParser clParser = profileInstance.createBuildOutputParser();
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                if (clParser == null) continue;
                clParser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info.isProblemReportingEnabled() ? markerGenerator : null));
                parserList.add(clParser);
                added = true;
            }
        }
        return added;
    }
}

