/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.ui;

import java.util.ArrayList;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.IRemoteLaunchAttributes;
import org.eclipse.ptp.remotetools.environment.launcher.internal.LaunchObserverIterator;
import org.eclipse.ptp.remotetools.environment.launcher.ui.Messages;
import org.eclipse.ptp.utils.ui.swt.ToolKit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LauncherExecutionTab
extends CLaunchConfigurationTab {
    protected Text programArgumentsText;
    private Combo observerList;
    private ArrayList observerIDs;
    private Text beforeCommandText;
    private Text afterCommandText;
    private boolean isValid;
    private TabModifyListener modifyListener;

    public void createControl(Composite parent) {
        this.setErrorMessage(null);
        GridLayout topLayout = new GridLayout();
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        this.modifyListener = new TabModifyListener();
        this.createArgumentGroup(topControl);
        this.createTargetObserverGroup(topControl);
        this.verifyContent();
    }

    protected void createArgumentGroup(Composite comp) {
        Group group = ToolKit.createGroup((Composite)comp, (String)Messages.LauncherExecutionTab_ArgumentsFrame_Title);
        this.programArgumentsText = ToolKit.createTextRow((Composite)group, (String)Messages.LauncherExecutionTab_ArgumentsFrame_CommandLineLabel, null);
        this.programArgumentsText.addModifyListener((ModifyListener)this.modifyListener);
    }

    protected void createTargetObserverGroup(Composite topControl) {
        Group group = ToolKit.createGroup((Composite)topControl, (String)Messages.LauncherExecutionTab_ObserverFrame_Title);
        this.observerList = ToolKit.createShortDropDownRow((Composite)group, (String)Messages.LauncherExecutionTab_ObserverFrame_ParserLabel);
        this.observerList.addSelectionListener((SelectionListener)this.modifyListener);
        this.beforeCommandText = ToolKit.createTextRow((Composite)group, (String)Messages.LauncherExecutionTab_ObserverFrame_BashCommandsBeforeLAbel, null, (int)4);
        this.beforeCommandText.addModifyListener((ModifyListener)this.modifyListener);
        this.afterCommandText = ToolKit.createTextRow((Composite)group, (String)Messages.LauncherExecutionTab_ObserverFrame_BashCommandsAfterLabel, null, (int)4);
        this.afterCommandText.addModifyListener((ModifyListener)this.modifyListener);
    }

    protected void verifyContent() {
        this.isValid = true;
        this.setErrorMessage(null);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String selectedObserverID;
        int selection = this.observerList.getSelectionIndex();
        if (selection == -1) {
            selection = 0;
        }
        if ((selectedObserverID = (String)this.observerIDs.get(selection)) != null) {
            try {
                if (!config.getAttribute("org.eclipse.debug.core.capture_output", false)) {
                    this.isValid = false;
                    this.setMessage(Messages.LauncherExecutionTab_Validation_ObserverAndNoConsole);
                }
            }
            catch (CoreException coreException) {}
        }
        return super.isValid(config) && this.isValid;
    }

    public boolean canSave() {
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AFTER_COMMAND", IRemoteLaunchAttributes.DEFAULT_AFTER_COMMAND);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.BEFORE_COMMAND", IRemoteLaunchAttributes.DEFAULT_BEFORE_COMMAND);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.OUTPUT_OBSERVER", IRemoteLaunchAttributes.DEFAULT_OUTPUT_OBSERVER);
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.FORWARD_X11", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String current;
            this.programArgumentsText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            this.observerList.removeAll();
            try {
                current = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.OUTPUT_OBSERVER", "");
            }
            catch (CoreException coreException) {
                current = "";
            }
            int selected = 0;
            this.observerList.add(Messages.LauncherExecutionTab_ObserverFrame_ObserverCombo_DefaultNoneOption);
            this.observerIDs = new ArrayList();
            this.observerIDs.add(null);
            LaunchObserverIterator iterator = RemoteLauncherPlugin.getLaunchObserverIterator();
            int index = 0;
            while (iterator.hasMoreElements()) {
                iterator.nextElement();
                String name = iterator.getName();
                String id = iterator.getID();
                if (name == null || id == null) continue;
                this.observerList.add(name);
                if (current.equals(id)) {
                    selected = index;
                }
                this.observerIDs.add(id);
                ++index;
            }
            this.observerList.select(selected);
            try {
                this.beforeCommandText.setText(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.BEFORE_COMMAND", ""));
            }
            catch (CoreException coreException) {
                this.beforeCommandText.setText(null);
            }
            try {
                this.afterCommandText.setText(configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AFTER_COMMAND", ""));
            }
            catch (CoreException coreException) {
                this.afterCommandText.setText(null);
            }
            this.verifyContent();
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchMessages.getFormattedString((String)"Launch.common.Exception_occurred_reading_configuration_EXCEPTION", (String)e.getStatus().getMessage()));
            LaunchUIPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.getAttributeValueFrom(this.programArgumentsText));
        int selection = this.observerList.getSelectionIndex();
        if (selection == -1) {
            selection = 0;
        }
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.OUTPUT_OBSERVER", (String)this.observerIDs.get(selection));
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.BEFORE_COMMAND", this.beforeCommandText.getText());
        configuration.setAttribute("org.eclipse.ptp.remotetools.environment.launcher.core.AFTER_COMMAND", this.afterCommandText.getText());
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return Messages.LauncherExecutionTab_Tab_Title;
    }

    public Image getImage() {
        return null;
    }

    private class TabModifyListener
    implements ModifyListener,
    SelectionListener {
        private TabModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            LauncherExecutionTab.this.verifyContent();
            LauncherExecutionTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            LauncherExecutionTab.this.verifyContent();
            LauncherExecutionTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            LauncherExecutionTab.this.verifyContent();
            LauncherExecutionTab.this.updateLaunchConfigurationDialog();
        }
    }
}

