/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rephraserengine.internal.core.preservation.Interval;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveOpList
implements Iterable<PrimitiveOp> {
    protected List<PrimitiveOp> list = new ArrayList<PrimitiveOp>();

    public PrimitiveOpList() {
    }

    public PrimitiveOpList(PrimitiveOp ... ops) {
        this();
        PrimitiveOp[] primitiveOpArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveOp op = primitiveOpArray[n2];
            this.add(op);
            ++n2;
        }
    }

    @Override
    public Iterator<PrimitiveOp> iterator() {
        return this.list.iterator();
    }

    public void add(PrimitiveOp op) {
        if (op instanceof PrimitiveOp.Alpha && this.needToMergeAlpha((PrimitiveOp.Alpha)op)) {
            this.mergeAlpha((PrimitiveOp.Alpha)op);
        } else {
            this.internalAdd(op);
        }
    }

    private boolean needToMergeAlpha(PrimitiveOp.Alpha alpha) {
        return !this.list.isEmpty() && this.lastOp() instanceof PrimitiveOp.Alpha && ((PrimitiveOp.Alpha)this.lastOp()).filename.equals(alpha.filename) && ((PrimitiveOp.Alpha)this.lastOp()).j.lb == alpha.j.lb;
    }

    private PrimitiveOp lastOp() {
        return this.list.get(this.list.size() - 1);
    }

    private void mergeAlpha(PrimitiveOp.Alpha alpha2) {
        PrimitiveOp.Alpha alpha1 = (PrimitiveOp.Alpha)this.list.remove(this.list.size() - 1);
        PrimitiveOp.Alpha newAlpha = PrimitiveOp.alpha(alpha1.filename, alpha1.k.lb, alpha1.k.lb + alpha1.k.cardinality() + alpha2.k.cardinality());
        this.internalAdd(newAlpha);
    }

    private void internalAdd(PrimitiveOp opToAdd) {
        for (PrimitiveOp existingOp : this.list) {
            if (!opToAdd.iaff().overlaps(existingOp.iaff())) continue;
            throw new IllegalArgumentException("Cannot add operation " + opToAdd + " because it overlaps " + existingOp);
        }
        this.list.add(opToAdd);
    }

    public int offset(String filename, int n) {
        int result = n;
        for (PrimitiveOp op : this.list) {
            result += op.adjust(filename, n);
        }
        return result;
    }

    public Interval inorm(String filename, Interval interval) {
        int lb = this.offset(filename, interval.lb);
        for (PrimitiveOp op : this.list) {
            if (!op.filename.equals(filename) || !op.daff(this).contains(lb)) continue;
            lb = op.daff((PrimitiveOpList)this).lb;
            break;
        }
        int ub = this.offset(filename, interval.ub);
        for (PrimitiveOp op : this.list) {
            if (!op.filename.equals(filename) || !op.daff(this).contains(ub)) continue;
            ub = op.daff((PrimitiveOpList)this).ub;
            break;
        }
        return new Interval(lb, ub);
    }

    public Interval dnorm(String filename, Interval interval) {
        int lb = interval.lb;
        for (PrimitiveOp op : this.list) {
            if (!op.filename.equals(filename) || !op.daff(this).contains(lb)) continue;
            lb = op.daff((PrimitiveOpList)this).lb;
            break;
        }
        int ub = interval.ub;
        for (PrimitiveOp op : this.list) {
            if (!op.filename.equals(filename) || !op.daff(this).contains(ub)) continue;
            ub = op.daff((PrimitiveOpList)this).ub;
            break;
        }
        return new Interval(lb, ub);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PrimitiveOp op : this.list) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(op);
        }
        return sb.toString();
    }
}

