/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteProcessBuilder
implements IRemoteProcessBuilder {
    private List<String> fCommandArgs;
    private IRemoteConnection fRemoteConnection;
    private IFileStore fRemoteDir = null;
    private boolean fRedirectErrorStream = false;

    public AbstractRemoteProcessBuilder(IRemoteConnection conn, List<String> command) {
        this.fRemoteConnection = conn;
        this.fCommandArgs = command;
    }

    public AbstractRemoteProcessBuilder(IRemoteConnection conn, String ... command) {
        this(conn, Arrays.asList(command));
    }

    @Override
    public IRemoteConnection connection() {
        return this.fRemoteConnection;
    }

    @Override
    public IRemoteProcessBuilder connection(IRemoteConnection conn) {
        this.fRemoteConnection = conn;
        return this;
    }

    @Override
    public List<String> command() {
        return this.fCommandArgs;
    }

    @Override
    public IRemoteProcessBuilder command(List<String> command) {
        this.fCommandArgs = command;
        return this;
    }

    @Override
    public IRemoteProcessBuilder command(String ... command) {
        this.fCommandArgs = Arrays.asList(command);
        return this;
    }

    @Override
    public IFileStore directory() {
        return this.fRemoteDir;
    }

    @Override
    public IRemoteProcessBuilder directory(IFileStore directory) {
        this.fRemoteDir = directory;
        return this;
    }

    @Override
    public abstract Map<String, String> environment();

    @Override
    public boolean redirectErrorStream() {
        return this.fRedirectErrorStream;
    }

    @Override
    public IRemoteProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.fRedirectErrorStream = redirectErrorStream;
        return this;
    }

    @Override
    public abstract IRemoteProcess start() throws IOException;
}

