/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.intrinsics.IntrinsicProcDescription;
import org.eclipse.photran.internal.core.intrinsics.Intrinsics;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FortranCompletionProposalComputer {
    private HashMap<String, TreeSet<Definition>> defs;
    private String scope;
    private int prefixIndex;
    private String prefix;
    private int suffixIndex;
    private String suffix;
    private int replOffset;
    private int replLen;
    private HashMap<Definition.Classification, Image> imageCache = new HashMap();

    FortranCompletionProposalComputer(HashMap<String, TreeSet<Definition>> defs, String scope, IDocument document, int offset) throws BadLocationException {
        this.defs = defs;
        this.scope = scope;
        this.prefixIndex = this.findPrefix(document, offset);
        this.prefix = document.get(this.prefixIndex, offset - this.prefixIndex).toLowerCase();
        this.suffixIndex = this.findSuffix(document, offset);
        this.suffix = document.get(offset, this.suffixIndex - offset).toLowerCase();
        this.replOffset = this.prefixIndex;
        this.replLen = this.suffixIndex - this.prefixIndex;
    }

    private int findPrefix(IDocument s, int offset) throws BadLocationException {
        --offset;
        while (offset >= 0) {
            char c = s.getChar(offset);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset + 1;
            }
            --offset;
        }
        return 0;
    }

    private int findSuffix(IDocument s, int offset) throws BadLocationException {
        int length = s.getLength();
        while (offset < length) {
            char c = s.getChar(offset);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                return offset;
            }
            ++offset;
        }
        return length;
    }

    public ICompletionProposal[] compute() throws BadLocationException {
        PhotranVPG.getInstance().debug("FortranCompletionProposalComputer#compute()", null);
        PhotranVPG.getInstance().debug("    Scope: " + this.scope, null);
        if (this.defs != null && this.defs.get(this.scope) != null) {
            PhotranVPG.getInstance().debug("    Definitions in scope: " + this.defs.get(this.scope).size(), null);
        }
        TreeSet<FortranCompletionProposal> proposals1 = new TreeSet<FortranCompletionProposal>();
        this.addProposalsFromDefs(proposals1);
        TreeSet<FortranCompletionProposal> proposals2 = new TreeSet<FortranCompletionProposal>();
        this.addIntrinsicProposals(proposals2);
        CompletionProposal[] result = new CompletionProposal[proposals1.size() + proposals2.size()];
        int i = 0;
        for (FortranCompletionProposal proposal : proposals1) {
            result[i++] = proposal.wrappedProposal;
        }
        for (FortranCompletionProposal proposal : proposals2) {
            result[i++] = proposal.wrappedProposal;
        }
        return result;
    }

    private void addProposalsFromDefs(TreeSet<FortranCompletionProposal> proposals) throws BadLocationException {
        while (true) {
            this.addProposals((Iterable<Definition>)this.defs.get(this.scope), proposals);
            int colon = this.scope.indexOf(58);
            if (colon < 0) break;
            this.scope = this.scope.substring(colon + 1);
        }
    }

    private void addProposals(Iterable<Definition> proposalsToConsider, TreeSet<FortranCompletionProposal> proposals) throws BadLocationException {
        if (proposalsToConsider != null) {
            for (Definition def : proposalsToConsider) {
                if (def.getClassification().equals((Object)Definition.Classification.MAIN_PROGRAM)) continue;
                String identifier = def.getDeclaredName();
                String canonicalizedId = def.getCanonicalizedName();
                if (!canonicalizedId.startsWith(this.prefix) || !canonicalizedId.endsWith(this.suffix)) continue;
                proposals.add(this.createProposal(identifier, def.describeClassification(), this.getImage(def.getClassification())));
            }
        }
    }

    private void addIntrinsicProposals(TreeSet<FortranCompletionProposal> proposals) throws BadLocationException {
        for (IntrinsicProcDescription proc : Intrinsics.getAllIntrinsicProcedures()) {
            String canonicalizedId = PhotranVPG.canonicalizeIdentifier((String)proc.genericName);
            if (!canonicalizedId.startsWith(this.prefix) || !canonicalizedId.endsWith(this.suffix)) continue;
            proposals.add(this.createProposal(proc.genericName.toLowerCase(), proc.description));
            for (String proposal : proc.getAllForms()) {
                proposals.add(this.createProposal(proposal.toLowerCase()));
            }
        }
    }

    private Image getImage(Definition.Classification classification) {
        if (!this.imageCache.containsKey(classification)) {
            this.imageCache.put(classification, this.getImageDescriptor(classification).createImage());
        }
        return this.imageCache.get(classification);
    }

    private ImageDescriptor getImageDescriptor(Definition.Classification classification) {
        switch (classification) {
            case DERIVED_TYPE_COMPONENT: 
            case IMPLICIT_LOCAL_VARIABLE: 
            case VARIABLE_DECLARATION: {
                return FortranElement.Variable.imageDescriptor();
            }
            case BLOCK_DATA: {
                return FortranElement.BlockData.imageDescriptor();
            }
            case DERIVED_TYPE: {
                return FortranElement.DerivedType.imageDescriptor();
            }
            case FUNCTION: {
                return FortranElement.Function.imageDescriptor();
            }
            case INTERFACE: {
                return FortranElement.Interface.imageDescriptor();
            }
            case MAIN_PROGRAM: {
                return FortranElement.MainProgram.imageDescriptor();
            }
            case MODULE: {
                return FortranElement.Module.imageDescriptor();
            }
            case SUBROUTINE: {
                return FortranElement.Subroutine.imageDescriptor();
            }
        }
        return FortranElement.unknownImageDescriptor();
    }

    private FortranCompletionProposal createProposal(String identifier) {
        return this.createProposal(identifier, null, null);
    }

    private FortranCompletionProposal createProposal(String identifier, String description) {
        return this.createProposal(identifier, description, null);
    }

    private FortranCompletionProposal createProposal(String identifier, String description, Image image) {
        return new FortranCompletionProposal(identifier, new CompletionProposal(identifier, this.replOffset, this.replLen, identifier.length(), image, this.displayString(identifier, description), null, null));
    }

    private String displayString(String identifier, String description) {
        if (description == null) {
            return identifier;
        }
        return String.valueOf(identifier) + " - " + description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FortranCompletionProposal
    implements Comparable<FortranCompletionProposal> {
        public final String canonicalizedId;
        public final CompletionProposal wrappedProposal;

        public FortranCompletionProposal(String identifier, CompletionProposal completionProposal) {
            this.canonicalizedId = PhotranVPG.canonicalizeIdentifier((String)identifier);
            this.wrappedProposal = completionProposal;
        }

        @Override
        public int compareTo(FortranCompletionProposal o) {
            return this.canonicalizedId.compareTo(o.canonicalizedId);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(this.getClass()) && ((FortranCompletionProposal)obj).canonicalizedId.equals(this.canonicalizedId);
        }

        public int hashCode() {
            return this.canonicalizedId.hashCode();
        }
    }
}

