/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.ArrayAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayAttribute<T extends Comparable<? super T>>
extends AbstractAttribute<List<? extends T>, ArrayAttribute<T>, ArrayAttributeDefinition<T>> {
    private List<T> value;

    public <U extends T> ArrayAttribute(ArrayAttributeDefinition<T> definition, List<U> initialValue) {
        super(definition);
        this.setValue(initialValue);
    }

    public ArrayAttribute(ArrayAttributeDefinition<T> definition, String initialValue) throws IllegalValueException {
        super(definition);
        this.setValueAsString(initialValue);
    }

    public <U extends T> ArrayAttribute(ArrayAttributeDefinition<T> definition, U[] initialValue) {
        super(definition);
        this.setValue(initialValue);
    }

    public synchronized <U extends T> void addAll(U[] value) {
        if (value != null) {
            this.value.addAll(Arrays.asList(value));
        }
    }

    public synchronized <U extends T> void addAll(List<U> value) {
        if (value != null) {
            this.value.addAll(value);
        }
    }

    @Override
    public synchronized List<T> getValue() {
        return this.value;
    }

    @Override
    public synchronized String getValueAsString() {
        return Arrays.toString(this.value.toArray());
    }

    @Override
    public boolean isValid(String string) {
        return true;
    }

    @Override
    public synchronized void setValue(List<? extends T> value) {
        this.value = value != null ? new ArrayList<T>(value) : new ArrayList<T>();
    }

    @Override
    public synchronized <U extends T> void setValue(U[] value) {
        this.value = value != null ? Arrays.asList((Comparable[])value.clone()) : new ArrayList<T>();
    }

    @Override
    public void setValueAsString(String string) throws IllegalValueException {
        String[] values = string.split("");
        try {
            this.setValue(values);
        }
        catch (ClassCastException e) {
            throw new IllegalValueException(e);
        }
    }

    @Override
    protected ArrayAttribute<T> doCopy() {
        return new ArrayAttribute<T>((ArrayAttributeDefinition)this.getDefinition(), this.value);
    }

    @Override
    protected synchronized int doCompareTo(ArrayAttribute<T> other) {
        int results = 0;
        Iterator<T> it1 = this.value.iterator();
        Iterator<T> it2 = other.value.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Comparable o2;
            Comparable o1 = (Comparable)it1.next();
            results = o1.compareTo(o2 = (Comparable)it2.next());
            if (results == 0) continue;
            return results;
        }
        return this.value.size() - other.value.size();
    }

    @Override
    protected synchronized boolean doEquals(ArrayAttribute<T> other) {
        return this.value.equals(other.value);
    }

    @Override
    protected synchronized int doHashCode() {
        return this.value.hashCode();
    }
}

