/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerAttributeDefinition
extends AbstractAttributeDefinition<Integer, IntegerAttribute, IntegerAttributeDefinition> {
    private final Integer minValue;
    private final Integer maxValue;
    private final Integer defaultValue;

    public IntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, Integer defaultValue) {
        super(uniqueId, name, description, display);
        this.defaultValue = defaultValue;
        this.minValue = 0;
        this.maxValue = Integer.MAX_VALUE;
    }

    public IntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, Integer defaultValue, Integer minValue, Integer maxValue) throws IllegalValueException {
        super(uniqueId, name, description, display);
        if (minValue > maxValue) {
            throw new IllegalArgumentException(Messages.IntegerAttributeDefinition_0);
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalValueException(Messages.IntegerAttributeDefinition_1);
        }
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public IntegerAttribute create() throws IllegalValueException {
        return new IntegerAttribute(this, this.defaultValue);
    }

    @Override
    public IntegerAttribute create(String value) throws IllegalValueException {
        return new IntegerAttribute(this, value);
    }

    public IntegerAttribute create(Integer value) throws IllegalValueException {
        return new IntegerAttribute(this, value);
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }
}

