/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.IMachineListener;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedNodeEvent;
import org.eclipse.ptp.internal.core.elements.events.MachineChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.NewNodeEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveNodeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMachine
extends Parent
implements IPMachineControl {
    private final ListenerList elementListeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();
    private String arch = Messages.PMachine_0;

    public PMachine(String id, IResourceManagerControl rm, IAttribute<?, ?, ?>[] attrs) {
        super(id, rm, 11, attrs);
        IntegerAttribute numNodes;
        IAttribute machineState = (EnumeratedAttribute)this.getAttribute(MachineAttributes.getStateAttributeDefinition());
        if (machineState == null) {
            machineState = MachineAttributes.getStateAttributeDefinition().create();
            this.addAttribute(machineState);
        }
        if ((numNodes = (IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())) == null) {
            try {
                numNodes = MachineAttributes.getNumNodesAttributeDefinition().create(0);
            }
            catch (IllegalValueException e) {
                throw new RuntimeException(e);
            }
            this.addAttribute(numNodes);
        }
    }

    @Override
    public void addChildListener(IMachineChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IMachineListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addNodeAttributes(Collection<IPNodeControl> nodeControls, IAttribute<?, ?, ?>[] attrs) {
        ArrayList<IPNode> nodes = new ArrayList<IPNode>(nodeControls.size());
        for (IPNodeControl node : nodeControls) {
            node.addAttributes(attrs);
        }
        this.fireChangedNodes(nodes);
    }

    @Override
    public void addNodes(Collection<IPNodeControl> nodeControls) {
        ArrayList<IPNode> nodes = new ArrayList<IPNode>(nodeControls.size());
        for (IPNodeControl node : nodeControls) {
            this.addChild(node);
            nodes.add(node);
        }
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        this.fireNewNodes(nodes);
    }

    @Override
    public synchronized String getArch() {
        return this.arch;
    }

    @Override
    public IPNode getNodeById(String id) {
        IPElementControl element = this.findChild(id);
        if (element != null) {
            return (IPNodeControl)element;
        }
        return null;
    }

    @Override
    public Collection<IPNodeControl> getNodeControls() {
        IPElementControl[] children = this.getChildren();
        ArrayList<IPNodeControl> nodes = new ArrayList<IPNodeControl>(children.length);
        IPElementControl[] iPElementControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElementControl element = iPElementControlArray[n2];
            nodes.add((IPNodeControl)element);
            ++n2;
        }
        return nodes;
    }

    @Override
    public IPNode[] getNodes() {
        Collection<IPNodeControl> nodes = this.getNodeControls();
        return nodes.toArray(new IPNode[nodes.size()]);
    }

    @Override
    public IResourceManager getResourceManager() {
        return (IResourceManager)((Object)this.getParent());
    }

    @Override
    public MachineAttributes.State getState() {
        return (MachineAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(MachineAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void removeChildListener(IMachineChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IMachineListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeNodes(Collection<IPNodeControl> nodeControls) {
        ArrayList<IPNode> nodes = new ArrayList<IPNode>(nodeControls.size());
        for (IPNodeControl node : nodeControls) {
            this.removeChild(node);
            nodes.add(node);
        }
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        this.fireRemoveNodes(nodes);
    }

    @Override
    public synchronized void setArch(String arch) {
        this.arch = arch;
    }

    @Override
    public int totalNodes() {
        try {
            ((IntegerAttribute)this.getAttribute(MachineAttributes.getNumNodesAttributeDefinition())).setValue(this.getChildren().length);
        }
        catch (IllegalValueException e) {
            throw new RuntimeException(e);
        }
        return this.size();
    }

    private void fireChangedMachine(AttributeManager attrs) {
        MachineChangeEvent e = new MachineChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedNodes(Collection<IPNode> nodes) {
        ChangedNodeEvent e = new ChangedNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewNodes(Collection<IPNode> nodes) {
        NewNodeEvent e = new NewNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveNodes(Collection<IPNode> nodes) {
        RemoveNodeEvent e = new RemoveNodeEvent(this, nodes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IMachineChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedMachine(attrs);
    }
}

