/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rmsystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.messages.Messages;
import org.eclipse.ptp.core.util.DebugUtil;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ResourceManagerPersistence {
    private static final String TAG_RESOURCEMANAGER_INDEX = "ResourceManagerIndex";
    private static final String TAG_RESOURCEMANAGERS = "ResourceManagers";
    private static final String TAG_RESOURCEMANGER = "ResourceManager";
    private static final String TAG_RESOURCEMANGER_CONFIGURATION = "Configuration";
    private static final String TAG_RESOURCEMANGER_ID = "ResourceManagerId";
    private static final String TAG_RESOURCEMANGER_RUNNING = "IsRunning";
    private final List<IResourceManagerControl> resourceManagers = new ArrayList<IResourceManagerControl>();
    private IResourceManagerControl savedCurrentResourceManager;
    private final List<IResourceManagerControl> rmsNeedStarting = new ArrayList<IResourceManagerControl>();

    public static void saveResourceManagers(File file, IResourceManagerControl[] resourceManagers) {
        block16: {
            if (DebugUtil.RM_TRACING) {
                System.out.println(String.valueOf(Messages.ResourceManagerPersistence_0) + file.getAbsolutePath());
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_RESOURCEMANAGERS);
            ResourceManagerPersistence.saveResourceManagers(memento, resourceManagers);
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    PTPCorePlugin.log(e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block16;
                    }
                    catch (IOException e2) {
                        PTPCorePlugin.log(e2);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    PTPCorePlugin.log(e);
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                PTPCorePlugin.log(e);
            }
        }
        if (DebugUtil.RM_TRACING) {
            System.out.println(Messages.ResourceManagerPersistence_1);
        }
    }

    private static void saveResourceManagers(XMLMemento memento, IResourceManagerControl[] resourceManagers) {
        int i = 0;
        while (i < resourceManagers.length) {
            IMemento child = memento.createChild(TAG_RESOURCEMANGER);
            child.putString(TAG_RESOURCEMANGER_ID, resourceManagers[i].getConfiguration().getResourceManagerId());
            child.putInteger(TAG_RESOURCEMANAGER_INDEX, i);
            boolean isRunning = resourceManagers[i].getState().equals((Object)ResourceManagerAttributes.State.STARTED);
            child.putString(TAG_RESOURCEMANGER_RUNNING, isRunning ? "true" : "false");
            IMemento grandchild = child.createChild(TAG_RESOURCEMANGER_CONFIGURATION);
            resourceManagers[i].getConfiguration().save(grandchild);
            ++i;
        }
    }

    public IResourceManagerControl[] getResourceManagerControls() {
        return this.resourceManagers.toArray(new IResourceManagerControl[0]);
    }

    public IResourceManagerControl[] getResourceManagerControlsNeedStarting() {
        return this.rmsNeedStarting.toArray(new IResourceManagerControl[0]);
    }

    public IResourceManager getSavedCurrentResourceManager() {
        return this.savedCurrentResourceManager;
    }

    public void loadResourceManagers(File file, IResourceManagerFactory[] factories) throws CoreException {
        this.rmsNeedStarting.clear();
        this.resourceManagers.clear();
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                this.loadResourceManagers(XMLMemento.createReadRoot((Reader)reader), factories);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    PTPCorePlugin.log(e);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                PTPCorePlugin.log(e);
            }
        }
    }

    private IResourceManagerFactory getResourceManagerFactory(IResourceManagerFactory[] factories, String id) {
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(id)) {
                return factories[i];
            }
            ++i;
        }
        return null;
    }

    private void loadResourceManagers(XMLMemento memento, IResourceManagerFactory[] factories) throws CoreException {
        IMemento[] children = memento.getChildren(TAG_RESOURCEMANGER);
        ArrayList statuses = new ArrayList();
        IResourceManagerControl[] tmpRMs = new IResourceManagerControl[children.length];
        ArrayList<IResourceManagerControl> rms = new ArrayList<IResourceManagerControl>(tmpRMs.length);
        int i = 0;
        while (i < children.length) {
            IMemento grandchild;
            IResourceManagerConfiguration configuration;
            String resourceManagerId = children[i].getString(TAG_RESOURCEMANGER_ID);
            int index = children[i].getInteger(TAG_RESOURCEMANAGER_INDEX);
            String isRunningRep = children[i].getString(TAG_RESOURCEMANGER_RUNNING);
            boolean isRunning = "true".equalsIgnoreCase(isRunningRep);
            IResourceManagerFactory factory = this.getResourceManagerFactory(factories, resourceManagerId);
            if (factory != null && (configuration = factory.loadConfiguration(grandchild = children[i].getChild(TAG_RESOURCEMANGER_CONFIGURATION))) != null) {
                tmpRMs[index] = factory.create(configuration);
                if (tmpRMs[index] != null) {
                    if (isRunning) {
                        this.rmsNeedStarting.add(tmpRMs[index]);
                    }
                    rms.add(tmpRMs[index]);
                }
            }
            ++i;
        }
        this.resourceManagers.addAll(rms);
        if (statuses.size() > 0) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.ptp.core", 4, statuses.toArray(new IStatus[0]), Messages.ResourceManagerPersistence_2, null));
        }
    }
}

