/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.proxy.core.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.proxy.runtime.server.ElementIDGenerator;
import org.eclipse.ptp.rm.proxy.core.element.IElement;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementManager {
    private Map<String, IElement> keyToElement = new HashMap<String, IElement>();
    private ElementManager addedElements;
    private ElementManager removedElements;
    private ElementManager changedElements;

    public ElementManager() {
    }

    private ElementManager(Collection<IElement> elements) {
        for (IElement element : elements) {
            this.keyToElement.put(element.getKey(), element);
        }
    }

    private void add(ElementManager other) {
        this.keyToElement.putAll(other.keyToElement);
    }

    void addElement(IElement element) {
        this.keyToElement.put(element.getKey(), element);
    }

    public ElementManager getAddedElements() {
        return this.addedElements;
    }

    public ElementManager getChangedElements() {
        return this.changedElements;
    }

    public ElementManager getCommon(ElementManager other) {
        HashSet<String> keys = new HashSet<String>(this.getElementIDs());
        keys.retainAll(other.getElementIDs());
        return this.getElementsByKeys(keys);
    }

    public IElement getElementByElementID(int elementID) {
        for (IElement element : this.getElements()) {
            if (element.getElementID() != elementID) continue;
            return element;
        }
        return null;
    }

    IElement getElementByKey(String key) {
        return this.keyToElement.get(key);
    }

    public int getElementIDByKey(String key) {
        return this.getElementByKey(key).getElementID();
    }

    private Set<String> getElementIDs() {
        return this.keyToElement.keySet();
    }

    public RangeSet getElementIDsAsRange() {
        RangeSet range = new RangeSet();
        for (IElement element : this.getElements()) {
            range.add(element.getElementID());
        }
        return range;
    }

    private Collection<IElement> getElements() {
        return this.keyToElement.values();
    }

    private ElementManager getElementsByKeys(Set<String> keys) {
        ElementManager ret = new ElementManager();
        for (String key : keys) {
            ret.addElement(this.getElementByKey(key));
        }
        return ret;
    }

    private ElementManager getModified(ElementManager other) {
        Collection<IElement> commonElements = this.getCommon(other).getElements();
        commonElements.removeAll(other.getElements());
        return new ElementManager(commonElements);
    }

    public ElementManager getRemovedElements() {
        return this.removedElements;
    }

    private ElementManager minus(ElementManager other) {
        HashSet<String> keys = new HashSet<String>(this.getElementIDs());
        keys.removeAll(other.getElementIDs());
        return this.getElementsByKeys(keys);
    }

    public List<String> serialize() {
        ArrayList<String> eventArgs = new ArrayList<String>();
        eventArgs.add(new Integer(this.size()).toString());
        for (IElement element : this.getElements()) {
            eventArgs.addAll(element.toStringArray());
        }
        return eventArgs;
    }

    public List<List<String>> serializeSplittedByParent() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        Map<String, ElementManager> parentKey_addedElements_Map = this.splitByParent();
        for (Map.Entry<String, ElementManager> pKey_elements : parentKey_addedElements_Map.entrySet()) {
            String parentKey = pKey_elements.getKey();
            ElementManager elements = pKey_elements.getValue();
            ArrayList<String> eventArgs = new ArrayList<String>();
            eventArgs.add(parentKey);
            eventArgs.addAll(elements.serialize());
            result.add(eventArgs);
        }
        return result;
    }

    private void setElementIDs(RangeSet rangeSet) {
        Iterator i = rangeSet.iterator();
        for (IElement e : this.getElements()) {
            e.setElementID(Integer.parseInt((String)i.next()));
        }
    }

    public int size() {
        return this.keyToElement.size();
    }

    public Map<String, ElementManager> splitByParent() {
        HashMap<String, ElementManager> ret = new HashMap<String, ElementManager>();
        for (IElement element : this.getElements()) {
            String parentKey = element.getParentKey();
            if (!ret.containsKey(parentKey)) {
                ret.put(parentKey, new ElementManager());
            }
            ((ElementManager)ret.get(parentKey)).addElement(element);
        }
        return ret;
    }

    public String toString() {
        return this.keyToElement.toString();
    }

    public void update(Collection<IElement> eList) {
        ElementManager newElements = new ElementManager(eList);
        this.addedElements = newElements.minus(this);
        this.addedElements.setElementIDs(ElementIDGenerator.getInstance().getUniqueIDs(this.addedElements.size()));
        this.removedElements = this.minus(newElements);
        this.changedElements = newElements.getModified(this);
        this.add(this.addedElements);
        this.getElementIDs().removeAll(this.removedElements.getElementIDs());
        for (IElement element : this.changedElements.getElements()) {
            IElement ownElement = this.getElementByKey(element.getKey());
            element.setElementID(ownElement.getElementID());
            ownElement.setAttributes(element);
        }
    }
}

