/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.ASTLexerFactory;
import org.eclipse.photran.internal.core.lexer.FixedFormReplacement;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuildingVisitor;
import org.eclipse.photran.internal.core.model.FortranParseTreeModelBuildingVisitor;
import org.eclipse.photran.internal.core.model.IFortranModelBuilder;
import org.eclipse.photran.internal.core.parser.IASTVisitor;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.core.sourceform.ISourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceForm;

public class FortranModelBuilder
implements IFortranModelBuilder {
    private TranslationUnit translationUnit;
    private Map<ICElement, Object> newElements;

    public void setTranslationUnit(ITranslationUnit tu) {
        if (!(tu instanceof TranslationUnit)) {
            throw new Error("Unexpected subclass of ITranslationUnit");
        }
        this.translationUnit = (TranslationUnit)tu;
    }

    public void parse(boolean quickParseMode) throws Exception {
        this.newElements = new HashMap<ICElement, Object>();
        boolean wasSuccessful = true;
        IAccumulatingLexer lexer = null;
        try {
            IFile file = this.translationUnit.getFile();
            ISourceForm sourceForm = this.determineSourceForm(file);
            String filename = this.determineFilename(file);
            lexer = new ASTLexerFactory().createLexer((Reader)new StringReader(this.translationUnit.getBuffer().getContents()), file, filename, sourceForm);
            FortranAST ast = new FortranAST(file, new Parser().parse(lexer), lexer.getTokenList());
            this.createSourceFormNode(SourceForm.descriptionFor((IFile)file));
            if (this.isParseTreeModelEnabled()) {
                LoopReplacer.replaceAllLoopsIn((ScopingNode)ast.getRoot());
                ast.accept((IASTVisitor)new FortranParseTreeModelBuildingVisitor(this.translationUnit, this));
            } else {
                ast.accept((IASTVisitor)new FortranModelBuildingVisitor(this.translationUnit, this));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (!e.getClass().equals(Exception.class)) {
                message = String.valueOf(e.getClass().getSimpleName()) + ": " + message;
            }
            FortranElement elt = this.createParseFailureNode((Parent)this.translationUnit, message);
            if (lexer != null) {
                int offset = lexer.getLastTokenFileOffset();
                int length = lexer.getLastTokenLength();
                int line = lexer.getLastTokenLine();
                if (offset >= 0 && length > 0) {
                    elt.setIdPos(offset, length);
                    elt.setPos(offset, length);
                    if (line > 0) {
                        elt.setLines(line, line);
                    }
                }
            }
            wasSuccessful = false;
        }
        this.setIsStructureKnown(wasSuccessful);
    }

    private String determineFilename(IFile file) {
        if (file == null) {
            return "";
        }
        if (this.isLocal(file)) {
            return file.getLocation().toFile().getAbsolutePath();
        }
        return file.getName();
    }

    private ISourceForm determineSourceForm(IFile file) {
        ISourceForm sourceForm = SourceForm.of((IFile)file);
        if (this.isLocal(file) && file.getProject() != null) {
            return sourceForm.configuredWith((Object)new IncludeLoaderCallback(file.getProject()));
        }
        return sourceForm;
    }

    private boolean isLocal(IFile file) {
        return file != null && file.getLocation() != null;
    }

    public void setIsStructureKnown(boolean isStructureKnown) {
        this.translationUnit.setIsStructureKnown(isStructureKnown);
    }

    private boolean isParseTreeModelEnabled() {
        return FortranPreferences.SHOW_PARSE_TREE.getValue();
    }

    private FortranElement createSourceFormNode(String desc) throws CModelException {
        desc = "<" + desc + ">";
        FortranElement.UnknownNode element = new FortranElement.UnknownNode((Parent)this.translationUnit, desc);
        this.translationUnit.addChild((ICElement)element);
        this.newElements.put((ICElement)element, element.getElementInfo());
        return element;
    }

    private FortranElement createParseFailureNode(Parent parent, String errorMessage) throws CModelException {
        FortranElement.ErrorNode element = new FortranElement.ErrorNode(parent, errorMessage);
        parent.addChild((ICElement)element);
        this.newElements.put((ICElement)element, element.getElementInfo());
        return element;
    }

    public FortranElement addF90Element(FortranElement element) throws CModelException {
        ICElement parent;
        if (element.getParent() == null) {
            element.setParent((ICElement)this.translationUnit);
        }
        if ((parent = element.getParent()) instanceof Parent) {
            ((Parent)parent).addChild((ICElement)element);
        }
        this.newElements.put((ICElement)element, element.getElementInfo());
        return element;
    }

    public void configureElement(FortranElement elt, Token nameToken) {
        if (nameToken != null) {
            if (!(elt instanceof FortranElement.ErrorNode) && !(elt instanceof FortranElement.UnknownNode)) {
                elt.setElementName(nameToken.getText());
            }
            if (nameToken.getPreprocessorDirective() == null || nameToken.getPreprocessorDirective() instanceof FixedFormReplacement) {
                int fileOffset = nameToken.getFileOffset();
                int length = nameToken.getLength();
                int line = nameToken.getLine();
                elt.setIdPos(fileOffset, length);
                elt.setPos(fileOffset, length);
                elt.setLines(line, line);
            }
        } else {
            elt.setElementName("(anonymous)");
        }
    }
}

