/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.swt.widgets.MessageBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIncludeAction
extends org.eclipse.cdt.internal.ui.editor.OpenIncludeAction {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(provider);
        this.setDescription(CUIPlugin.getResourceString((String)"OpenIncludeAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString((String)"OpenIncludeAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, (String)"lcl16/", (String)"org.eclipse.cdt.ui.open_include.gif");
        this.fSelectionProvider = provider;
    }

    public void run() {
        IInclude include = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (include == null) {
            return;
        }
        try {
            Object fileToOpen;
            int nElementsFound;
            ArrayList<URI> filesFound = new ArrayList<URI>(4);
            IResource res = include.getUnderlyingResource();
            String fullFileName = include.getFullFileName();
            if (fullFileName != null) {
                URI locationURI;
                URI includeURI;
                IFileStore fileStore;
                Path fullPath = new Path(fullFileName);
                if (fullPath.isAbsolute() && fullPath.toFile().exists()) {
                    filesFound.add(fullPath.toFile().toURI());
                }
                if (filesFound.isEmpty() && !(fileStore = EFS.getStore((URI)(includeURI = this.replacePath(locationURI = include.getLocationURI(), fullFileName)))).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    filesFound.add(includeURI);
                }
            }
            if (filesFound.isEmpty() && res != null) {
                boolean isSystemInclude = include.isStandard();
                IProject proj = res.getProject();
                String includeName = include.getElementName();
                URI locationURI = include.getLocationURI();
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(proj);
                if (provider != null) {
                    IScannerInfo info = provider.getScannerInformation(res);
                    if (info == null) {
                        info = provider.getScannerInformation((IResource)proj);
                    }
                    if (info != null) {
                        ExtendedScannerInfo scanInfo = new ExtendedScannerInfo(info);
                        if (!isSystemInclude) {
                            Path pathURI = new Path(locationURI.toString());
                            String currentDir = pathURI.removeLastSegments(1).toOSString();
                            this.findFile(new String[]{currentDir}, includeName, filesFound);
                            if (filesFound.isEmpty()) {
                                String[] localIncludePaths = scanInfo.getLocalIncludePath();
                                String[] includePaths = new String[localIncludePaths.length];
                                int i = 0;
                                while (i < localIncludePaths.length) {
                                    includePaths[i] = String.valueOf(locationURI.getScheme()) + "://" + locationURI.getHost() + new String(localIncludePaths[i]);
                                    ++i;
                                }
                                this.findFile(includePaths, includeName, filesFound);
                            }
                        }
                        if (filesFound.isEmpty()) {
                            String[] includePaths = scanInfo.getIncludePaths();
                            String[] newIncludePaths = new String[includePaths.length];
                            int i = 0;
                            while (i < includePaths.length) {
                                newIncludePaths[i] = String.valueOf(locationURI.getScheme()) + "://" + locationURI.getHost() + new String(includePaths[i]);
                                ++i;
                            }
                            this.findFile(newIncludePaths, includeName, filesFound);
                        }
                    }
                    if (filesFound.isEmpty()) {
                        IResource resource = include.getCProject().getProject().findMember(include.getElementName());
                        if (!isSystemInclude && resource != null && resource instanceof IFile) {
                            filesFound.add(resource.getLocationURI());
                        }
                    }
                }
            }
            if ((nElementsFound = filesFound.size()) == 0) {
                this.noElementsFound();
                fileToOpen = null;
            } else {
                fileToOpen = nElementsFound == 1 ? (Object)filesFound.get(0) : this.chooseFile(filesFound);
            }
            if (fileToOpen != null) {
                EditorUtility.openInEditor((URI)((URI)fileToOpen), (ICElement)include.getCProject());
            }
        }
        catch (CModelException e) {
            CUIPlugin.log((IStatus)e.getStatus());
        }
        catch (CoreException e) {
            CUIPlugin.log((IStatus)e.getStatus());
        }
    }

    private void noElementsFound() {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString((String)"OpenIncludeAction.error"));
        errorMsg.setMessage(CUIPlugin.getResourceString((String)"OpenIncludeAction.error.description"));
        errorMsg.open();
    }

    private boolean isInProject(IPath path) {
        return this.getWorkspaceRoot().getFileForLocation(path) != null;
    }

    private IPath[] resolveIncludeLink(IPath path) {
        IFile[] files;
        if (!this.isInProject(path) && (files = ResourceLookup.findFilesForLocation((IPath)path)).length > 0) {
            IPath[] paths = new IPath[files.length];
            int i = 0;
            while (i < files.length) {
                paths[i] = files[i].getFullPath();
                ++i;
            }
            return paths;
        }
        return new IPath[]{path};
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Unable to fully structure code
     */
    private void findFile(String[] includePaths, String name, ArrayList<URI> list) throws CoreException {
        includeFile = new Path(name);
        if (includeFile.isAbsolute() && (includeFile = PathUtil.getCanonicalPath((IPath)includeFile)).toFile().exists()) {
            list.add(includeFile.toFile().toURI());
            return;
        }
        foundSet = new HashSet<IPath>();
        var9_6 = includePaths;
        var8_7 = includePaths.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            includePath = var9_6[var7_8];
            path = PathUtil.getCanonicalPath((IPath)new Path(includePath).append((IPath)includeFile));
            file = path.toFile();
            if (file.exists()) {
                var16_17 = paths = this.resolveIncludeLink(path);
                var15_16 = paths.length;
                var14_15 = 0;
                while (var14_15 < var15_16) {
                    p = var16_17[var14_15];
                    if (foundSet.add(p)) {
                        list.add(p.toFile().toURI());
                    }
                    ++var14_15;
                }
            } else {
                try {
                    uri = new URI(path.toPortableString());
                    fileStore = EFS.getStore((URI)uri);
                    if (fileStore.fetchInfo().isDirectory() || !fileStore.fetchInfo().exists()) ** GOTO lbl35
                    list.add(uri);
                }
                catch (URISyntaxException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
lbl35:
            // 4 sources

            ++var7_8;
        }
    }

    private Object chooseFile(ArrayList<URI> filesFound) {
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof URI) {
                    URI uri = (URI)element;
                    String pathString = EFSExtensionManager.getDefault().getPathFromURI(uri);
                    Path path = new Path(pathString);
                    return String.valueOf(path.lastSegment()) + " - " + path.toString();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(CUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)renderer, false, false);
        dialog.setTitle(CUIPlugin.getResourceString((String)DIALOG_TITLE));
        dialog.setMessage(CUIPlugin.getResourceString((String)DIALOG_MESSAGE));
        dialog.setElements(filesFound);
        if (dialog.open() == 0) {
            return (IFile)((IPath)dialog.getSelectedElement()).toFile();
        }
        return null;
    }

    private static IInclude getIncludeStatement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof IInclude) {
            return (IInclude)element;
        }
        return null;
    }

    private URI replacePath(URI u, String path) {
        try {
            return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), path, u.getQuery(), u.getFragment());
        }
        catch (URISyntaxException e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
    }
}

