/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ptp.debug.internal.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo ruler = null;
    private IWorkbenchPart targetPart = null;
    private ToggleBreakpointAdapter breakpointAdapter = null;
    private static final ISelection EMPTY_SELECTION = new ISelection(){

        public boolean isEmpty() {
            return true;
        }
    };

    public ToggleBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo ruler) {
        super(Messages.ToggleBreakpointRulerAction_0);
        this.ruler = ruler;
        this.setTargetPart(part);
        this.breakpointAdapter = new ToggleBreakpointAdapter();
        this.setId(IPTPDebugUIConstants.ACTION_SET_BREAKPOINT);
    }

    public void dispose() {
        this.setTargetPart(null);
        this.ruler = null;
    }

    public void run() {
        try {
            this.breakpointAdapter.toggleLineBreakpoints(this.getTargetPart(), this.getTargetSelection());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)Messages.ToggleBreakpointRulerAction_1, (String)Messages.ToggleBreakpointRulerAction_2, (IStatus)e.getStatus());
        }
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.ruler;
    }

    private IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    private void setTargetPart(IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    private ISelection getTargetSelection() {
        IDocument doc = this.getDocument();
        if (doc != null) {
            int line = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                IRegion region = doc.getLineInformation(line);
                return new TextSelection(doc, region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        return EMPTY_SELECTION;
    }

    private IDocument getDocument() {
        ITextEditor textEditor;
        IDocumentProvider provider;
        IWorkbenchPart targetPart = this.getTargetPart();
        if (targetPart instanceof ITextEditor && (provider = (textEditor = (ITextEditor)targetPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)textEditor.getEditorInput());
        }
        return null;
    }
}

