/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.ui.sourcelookup.AbstractSourceContainerBrowser;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.debug.internal.core.sourcelookup.ResourceMappingSourceContainer;
import org.eclipse.ptp.debug.internal.ui.sourcelookup.ResourceMappingSourceContainerDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceMappingSourceContainerBrowser
extends AbstractSourceContainerBrowser {
    public ISourceContainer[] addSourceContainers(Shell shell, ISourceLookupDirector director) {
        ResourceMappingSourceContainerDialog dialog;
        IRemoteConnection conn = this.getRemoteConnection(director.getLaunchConfiguration());
        if (conn != null && (dialog = new ResourceMappingSourceContainerDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(), conn)).open() == 0) {
            ArrayList<ResourceMappingSourceContainer> containers = new ArrayList<ResourceMappingSourceContainer>();
            containers.add(new ResourceMappingSourceContainer(dialog.getPath(), dialog.getContainer()));
            return containers.toArray(new ISourceContainer[containers.size()]);
        }
        return new ISourceContainer[0];
    }

    public boolean canEditSourceContainers(ISourceLookupDirector director, ISourceContainer[] containers) {
        return containers.length == 1 && containers[0].getType().getId().equals(FolderSourceContainer.TYPE_ID);
    }

    public ISourceContainer[] editSourceContainers(Shell shell, ISourceLookupDirector director, ISourceContainer[] containers) {
        IRemoteConnection conn = this.getRemoteConnection(director.getLaunchConfiguration());
        if (conn != null) {
            ResourceMappingSourceContainerDialog dialog = new ResourceMappingSourceContainerDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(), conn);
            ResourceMappingSourceContainer container = (ResourceMappingSourceContainer)containers[0];
            dialog.setInitialSelection(container.getContainer());
            if (dialog.open() == 0) {
                container.dispose();
                ArrayList<ResourceMappingSourceContainer> list = new ArrayList<ResourceMappingSourceContainer>();
                list.add(new ResourceMappingSourceContainer(dialog.getPath(), dialog.getContainer()));
                return list.toArray(new ISourceContainer[list.size()]);
            }
        }
        return new ISourceContainer[0];
    }

    private IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration) {
        IResourceManagerControl rm;
        String rmName = null;
        try {
            rmName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        }
        catch (CoreException coreException) {}
        if (rmName != null && (rm = (IResourceManagerControl)PTPCorePlugin.getDefault().getModelManager().getResourceManagerFromUniqueName(rmName)) != null) {
            IRemoteConnectionManager connMgr;
            String remId = rm.getConfiguration().getRemoteServicesId();
            String connName = rm.getConfiguration().getConnectionName();
            IRemoteServices rsrv = PTPRemoteCorePlugin.getDefault().getRemoteServices(remId);
            if (rsrv != null && (connMgr = rsrv.getConnectionManager()) != null) {
                return connMgr.getConnection(connName);
            }
        }
        return null;
    }
}

