/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.ui;

import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PDebugModel;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.PVariableManager;
import org.eclipse.ptp.debug.ui.messages.Messages;
import org.eclipse.ptp.ui.managers.JobManager;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class UIDebugManager
extends JobManager
implements IBreakpointListener {
    private final PVariableManager jobVarMgr = new PVariableManager();
    private PDebugModel debugModel = null;
    private IPSession currentSession = null;
    private boolean prefAutoUpdateVarOnSuspend = false;
    private boolean prefAutoUpdateVarOnChange = false;
    private boolean prefRegisterProc0 = true;
    private final Preferences.IPropertyChangeListener propertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            String preferenceType = event.getProperty();
            String value = (String)event.getNewValue();
            if (preferenceType.equals(IPDebugConstants.PREF_PTP_DEBUG_REGISTER_PROC_0)) {
                UIDebugManager.this.prefRegisterProc0 = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND)) {
                UIDebugManager.this.prefAutoUpdateVarOnSuspend = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE)) {
                UIDebugManager.this.prefAutoUpdateVarOnChange = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_PTP_DEBUG_COMM_TIMEOUT)) {
                IPJob[] iPJobArray = UIDebugManager.this.getJobs();
                int n = iPJobArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPJob job = iPJobArray[n2];
                    IPSession session = UIDebugManager.this.getDebugSession(job);
                    if (session != null) {
                        session.getPDISession().setRequestTimeout(new Integer(value).longValue());
                    }
                    ++n2;
                }
            }
        }
    };

    public UIDebugManager() {
        PTPDebugCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.debugModel = PTPDebugCorePlugin.getDebugModel();
        this.initializePreferences();
    }

    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (PTPDebugUIPlugin.isPTPDebugPerspective() && breakpoint instanceof ICLineBreakpoint) {
            WorkbenchJob uiJob = new WorkbenchJob(Messages.UIDebugManager_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.schedule();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void fireJobChangedEvent(int type, String cur_jid, String pre_jid) {
        this.updateBreakpointMarker("Root");
        this.removeAllRegisterElements(pre_jid);
        super.fireJobChangedEvent(type, cur_jid, pre_jid);
    }

    public synchronized void fireSetEvent(int eventType, IElement[] elements, IElementSet cur_set, IElementSet pre_set) {
        IPSession session = this.getDebugSession(this.getJob());
        if (session != null) {
            switch (eventType) {
                case 0: {
                    TaskSet cTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.createSet(session, cur_set.getName(), cTasks);
                    break;
                }
                case 1: {
                    this.debugModel.deleteSet(session, cur_set.getName());
                    break;
                }
                case 2: {
                    if (cur_set == null) break;
                    this.updateBreakpointMarker(cur_set.getName());
                    this.updateRegisterUnRegisterElements(cur_set, pre_set, this.getCurrentJobId());
                    break;
                }
                case 3: {
                    TaskSet aTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.addTasks(session, cur_set.getName(), aTasks);
                    break;
                }
                case 4: {
                    TaskSet rTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.removeTasks(session, cur_set.getName(), rTasks);
                }
            }
            super.fireSetEvent(eventType, elements, cur_set, pre_set);
        }
    }

    public String getCurrentJobId() {
        IPJob job = this.getJob();
        if (job != null) {
            return job.getID();
        }
        return "";
    }

    public IPSession getCurrentSession() {
        if (this.currentSession == null) {
            this.currentSession = this.getDebugSession(this.getJob());
        }
        return this.currentSession;
    }

    public IPSession getDebugSession(IPJob job) {
        if (job == null) {
            return null;
        }
        return this.debugModel.getSession(job);
    }

    public IPSession getDebugSession(String job_id) {
        if (this.isNoJob(job_id)) {
            return null;
        }
        return this.getDebugSession(this.findJobById(job_id));
    }

    public PVariableManager getJobVariableManager() {
        return this.jobVarMgr;
    }

    public TaskSet getSelectedRegisteredTasks(Object obj) {
        IDebugTarget target = null;
        if (obj instanceof IStackFrame) {
            target = ((IStackFrame)obj).getDebugTarget();
        } else if (obj instanceof IThread) {
            target = ((IThread)obj).getDebugTarget();
        } else if (obj instanceof IDebugTarget) {
            target = (IDebugTarget)obj;
        }
        if (target instanceof IPDebugTarget) {
            return ((IPDebugTarget)target).getTasks();
        }
        return null;
    }

    public TaskSet getTasks(IPSession session, String set_id) throws CoreException {
        return this.debugModel.getTasks(session, set_id);
    }

    public TaskSet getTasks(String set_id) throws CoreException {
        return this.getTasks(this.getCurrentJobId(), set_id);
    }

    public TaskSet getTasks(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_1, null));
        }
        return this.getTasks(session, set_id);
    }

    public String getValueText(int taskID, IToolTipProvider provider) {
        IPJob job = this.getJob();
        if (job == null) {
            return Messages.UIDebugManager_2;
        }
        return this.getJobVariableManager().getValue(this.getJob(), taskID, provider);
    }

    public boolean isAutoUpdateVarOnChange() {
        return this.prefAutoUpdateVarOnChange;
    }

    public boolean isAutoUpdateVarOnSuspend() {
        return this.prefAutoUpdateVarOnSuspend;
    }

    public boolean isDebugMode(IPJob job) {
        if (job == null) {
            return false;
        }
        return job.isDebug();
    }

    public boolean isDebugMode(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isDebugMode(this.findJobById(job_id));
    }

    public boolean isEnabledDefaultRegister() {
        return this.prefRegisterProc0;
    }

    public boolean isRunning(IPJob job) {
        return job != null && job.getState() != JobAttributes.State.COMPLETED;
    }

    public boolean isRunning(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isRunning(this.findJobById(job_id));
    }

    public void registerElements(final IElement[] elements) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_3, this.getJob(), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IPJob job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                TaskSet tasks = session.getTasks(-1);
                IElement[] iElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IElement element = iElementArray[n2];
                    if (!element.isRegistered()) {
                        try {
                            tasks.set(Integer.parseInt(element.getName()));
                        }
                        catch (NumberFormatException e) {
                            PTPDebugCorePlugin.log((Throwable)e);
                        }
                    }
                    ++n2;
                }
                UIDebugManager.this.registerTasks(session, tasks);
                return Status.OK_STATUS;
            }
        });
    }

    public void registerTasks(IPSession session, TaskSet tasks) {
        session.createDebugTarget(tasks, true, true);
    }

    public void removeAllRegisterElements(String job_id) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_4, this.findJobById(job_id), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IPJob job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                session.deleteDebugTargets(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        });
    }

    public void removeJob(IPJob job) {
        if (job.isDebug()) {
            this.debugModel.shutdownSession(job);
        }
        super.removeJob(job);
    }

    public void resume() throws CoreException {
        this.resume(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void resume(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_5, null));
        }
        try {
            session.getPDISession().resume(this.getTasks(session, set_id), false);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void setJob(IPJob job) {
        this.currentSession = this.getDebugSession(job);
        super.setJob(job);
    }

    public void shutdown() {
        PTPDebugCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.jobVarMgr.shutdown();
        super.shutdown();
    }

    public void stepInto() throws CoreException {
        this.stepInto(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepInto(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_6, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepInto(tasks, 1);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepOver() throws CoreException {
        this.stepOver(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepOver(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_7, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepOver(tasks, 1);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepReturn() throws CoreException {
        this.stepReturn(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepReturn(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_8, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepReturn(tasks, 0);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void suspend() throws CoreException {
        this.suspend(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void suspend(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_9, null));
        }
        try {
            session.getPDISession().suspend(this.getTasks(session, set_id));
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void terminate() throws CoreException {
        this.terminate(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void terminate(String job_id, String set_id) throws CoreException {
        IPJob job = this.findJobById(job_id);
        if (this.isDebugMode(job)) {
            IPSession session = this.getDebugSession(job);
            if (session == null) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_10, null));
            }
            try {
                session.getPDISession().terminate(this.getTasks(session, set_id));
            }
            catch (PDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    public void unregisterElements(final IElement[] elements) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_11, this.getJob(), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IPJob job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                TaskSet tasks = session.getTasks(-1);
                IElement[] iElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IElement element = iElementArray[n2];
                    if (element.isRegistered()) {
                        try {
                            tasks.set(Integer.parseInt(element.getName()));
                        }
                        catch (NumberFormatException e) {
                            PTPDebugCorePlugin.log((Throwable)e);
                        }
                    }
                    ++n2;
                }
                UIDebugManager.this.unregisterTasks(session, tasks);
                return Status.OK_STATUS;
            }
        });
    }

    public void unregisterTasks(IPSession session, TaskSet tasks) {
        session.deleteDebugTarget(tasks, true, true);
    }

    public void updateBreakpointMarker(final String cur_sid) {
        WorkbenchJob uiJob = new WorkbenchJob(Messages.UIDebugManager_12){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    PDebugModel.updatePBreakpoints((String)cur_sid, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    public void updateCurrentJobVariableValues() {
        this.getJobVariableManager().updateValues(this.getJob());
    }

    public void updateRegisterUnRegisterElements(final IElementSet curSet, IElementSet preSet, String job_id) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_13, this.findJobById(job_id), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IPJob job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                session.reloadDebugTargets(UIDebugManager.this.debugModel.getTasks(session, curSet.getID()), true, false);
                monitor.done();
                return Status.OK_STATUS;
            }
        });
    }

    private TaskSet convertElementsToBitList(IPSession session, IElement[] elements) {
        TaskSet tasks = session.getTasks(-1);
        IElement[] iElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IElement element = iElementArray[n2];
            tasks.set(Integer.parseInt(element.getName()));
            ++n2;
        }
        return tasks;
    }

    private void initializePreferences() {
        Preferences prefStore = PTPDebugCorePlugin.getDefault().getPluginPreferences();
        this.prefRegisterProc0 = prefStore.getBoolean(IPDebugConstants.PREF_PTP_DEBUG_REGISTER_PROC_0);
        this.prefAutoUpdateVarOnSuspend = prefStore.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND);
        this.prefAutoUpdateVarOnChange = prefStore.getBoolean(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE);
    }

    private static interface IDebugProgressMonitor {
        public IStatus runDebugJob(IPJob var1, IPSession var2, IProgressMonitor var3);
    }

    private class UIDebugWorkbenchJob
    extends WorkbenchJob {
        private IPJob job;
        private IPSession session;
        private IDebugProgressMonitor debugMonitor;

        public UIDebugWorkbenchJob(boolean runInDialog, String name, IPJob job, IDebugProgressMonitor debugMonitor) {
            super(name);
            this.job = null;
            this.session = null;
            this.debugMonitor = null;
            this.job = job;
            this.debugMonitor = debugMonitor;
            if (runInDialog) {
                PlatformUI.getWorkbench().getProgressService().showInDialog(null, (Job)this);
            }
            this.schedule();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            return this.debugMonitor.runDebugJob(this.job, this.session, monitor);
        }

        public boolean shouldRun() {
            this.session = UIDebugManager.this.getDebugSession(this.job);
            if (this.session == null) {
                return false;
            }
            if (!this.session.isReady()) {
                return false;
            }
            return super.shouldRun();
        }
    }
}

