/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileStore;

public class RemoteToolsFileSystem
extends FileSystem {
    private static RemoteToolsFileSystem instance = new RemoteToolsFileSystem();

    public static String getConnectionNameFor(URI uri) {
        String name = uri.getAuthority();
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return name;
    }

    public static RemoteToolsFileSystem getInstance() {
        return instance;
    }

    public static URI getURIFor(String connectionName, String path) {
        String authority;
        try {
            authority = URLEncoder.encode(connectionName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            return new URI("remotetools", authority, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public int attributes() {
        return 102;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        try {
            return RemoteToolsFileStore.getInstance(uri);
        }
        catch (Exception e) {
            PTPRemoteCorePlugin.log((Throwable)e);
            return EFS.getNullFileSystem().getStore(uri);
        }
    }
}

