/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsProcess;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.RemoteProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsProcessBuilder
extends AbstractRemoteProcessBuilder {
    private final RemoteToolsConnection fConnection;
    private final RemoteToolsFileManager fFileMgr;
    private final Map<String, String> fRemoteEnv;
    private Map<String, String> fNewRemoteEnv = null;

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, RemoteToolsFileManager fileMgr, List<String> command) {
        super((IRemoteConnection)conn, command);
        this.fConnection = conn;
        this.fFileMgr = fileMgr;
        this.fRemoteEnv = conn.getEnv();
    }

    public RemoteToolsProcessBuilder(RemoteToolsConnection conn, RemoteToolsFileManager fileMgr, String ... command) {
        this(conn, fileMgr, Arrays.asList(command));
    }

    public IFileStore directory() {
        IFileStore dir = super.directory();
        if (dir == null) {
            dir = this.fFileMgr.getResource(this.connection().getWorkingDirectory());
            this.directory(dir);
        }
        return dir;
    }

    public Map<String, String> environment() {
        if (this.fNewRemoteEnv == null) {
            this.fNewRemoteEnv = new HashMap<String, String>();
            this.fNewRemoteEnv.putAll(this.fRemoteEnv);
        }
        return this.fNewRemoteEnv;
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        try {
            IRemoteExecutionManager exeMgr = this.fConnection.createExecutionManager();
            IRemoteExecutionTools exeTools = exeMgr.getExecutionTools();
            IRemoteScript script = exeTools.createScript();
            if (this.directory() != null) {
                String setWorkingDirStr = "cd " + this.directory().toURI().getPath();
                script.setScript(new String[]{setWorkingDirStr, remoteCmd});
            } else {
                script.setScript(remoteCmd);
            }
            if (this.fNewRemoteEnv != null) {
                for (Map.Entry<String, String> entry : this.fNewRemoteEnv.entrySet()) {
                    String oldValue = this.fRemoteEnv.get(entry.getKey());
                    if (oldValue != null && oldValue.equals(entry.getValue())) continue;
                    script.addEnvironment(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                }
            }
            RemoteProcess process = exeTools.executeProcess(script);
            return new RemoteToolsProcess((Process)process, this.redirectErrorStream());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }
}

