/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core.environment;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.environment.ConfigFactory;
import org.eclipse.ptp.remote.remotetools.core.environment.TargetConfig;
import org.eclipse.ptp.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetVariables;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTPTargetControl
extends SSHTargetControl
implements ITargetVariables {
    private static final int NOT_OPERATIONAL = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;
    public static final String DEFAULT_CIPHER = RemotetoolsPlugin.CIPHER_DEFAULT;
    private ConfigFactory configFactory;
    private TargetConfig currentTargetConfig;
    private ITargetElement targetElement;
    private IRemoteExecutionManager executionManager;
    private int state = 1;
    private RemoteToolsConnection connection = null;

    public PTPTargetControl(ITargetElement element) throws CoreException {
        this.targetElement = element;
        this.configFactory = new ConfigFactory(this.targetElement.getAttributes());
        this.currentTargetConfig = this.configFactory.createTargetConfig();
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        block8: {
            monitor.beginTask(Messages.TargetControl_create_MonitorConnecting, 1);
            if (this.currentTargetConfig.isPasswordAuth()) {
                this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, this.currentTargetConfig.getConnectionAddress(), this.currentTargetConfig.getConnectionPort(), this.currentTargetConfig.getLoginUserName(), this.currentTargetConfig.getLoginPassword(), this.currentTargetConfig.getCipherType(), this.currentTargetConfig.getConnectionTimeout() * 1000));
            } else {
                this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, this.currentTargetConfig.getConnectionAddress(), this.currentTargetConfig.getConnectionPort(), this.currentTargetConfig.getLoginUserName(), this.currentTargetConfig.getKeyPath(), this.currentTargetConfig.getKeyPassphrase(), this.currentTargetConfig.getCipherType(), this.currentTargetConfig.getConnectionTimeout() * 1000));
            }
            try {
                this.setState(2);
                super.create(monitor);
                if (!monitor.isCanceled()) break block8;
                this.disconnect();
                this.setState(1);
                monitor.done();
                return true;
            }
            catch (CoreException e) {
                this.disconnect();
                this.setState(1);
                monitor.done();
                throw e;
            }
        }
        this.setState(3);
        if (this.connection != null) {
            this.connection.fireConnectionChangeEvent(this.connection, 2);
        }
        monitor.worked(1);
        try {
            this.executionManager = super.createRemoteExecutionManager();
        }
        catch (RemoteConnectionException e) {
            this.disconnect();
            this.setState(1);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remote.core.remotetools", e.getMessage()));
        }
        monitor.done();
        return true;
    }

    public IRemoteExecutionManager createExecutionManager() throws RemoteConnectionException {
        if (!this.isConnected()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        return super.createRemoteExecutionManager();
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) {
        Assert.isTrue((boolean)this.isConnected());
        ITargetControl.TargetSocket socket = new ITargetControl.TargetSocket();
        socket.host = this.currentTargetConfig.getConnectionAddress();
        socket.port = port;
        return socket;
    }

    public void destroy() throws CoreException {
        try {
            this.terminateJobs(null);
        }
        finally {
            this.disconnect();
        }
    }

    public Map<String, String> getAttributes() {
        return this.targetElement.getAttributes();
    }

    public IRemoteExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public String getName() {
        return this.targetElement.getName();
    }

    public String getSystemWorkspace() {
        return this.currentTargetConfig.getSystemWorkspace();
    }

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        try {
            this.setState(4);
            super.kill(monitor);
        }
        finally {
            this.setState(1);
            if (this.connection != null) {
                this.connection.fireConnectionChangeEvent(this.connection, 1);
            }
        }
        return true;
    }

    public synchronized int query() {
        switch (this.state) {
            case 1: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                if (this.isConnected()) {
                    return 2;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean resume(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, Messages.TargetControl_resume_CannotResume, null));
    }

    public void setConnection(RemoteToolsConnection conn) {
        this.connection = conn;
    }

    public boolean stop(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, Messages.TargetControl_stop_CannotPause, null));
    }

    public void updateConfiguration() throws CoreException {
        this.configFactory = new ConfigFactory(this.targetElement.getAttributes());
        this.currentTargetConfig = this.configFactory.createTargetConfig();
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    protected String getPluginId() {
        return "org.eclipse.ptp.remote.core.remotetools";
    }
}

