/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class IndexBuildSequenceController
implements IResourceChangeListener {
    public static String INDEX_AFTER_BUILD_OPTION_KEY = "INDEX_AFTER_BUILD";
    public static String INDEX_STATUS_KEY = "INDEX_STATUS";
    public static String BUILD_STATUS_KEY = "BUILD_STATUS";
    public static final String TRUE = String.valueOf(true);
    public static final String FALSE = String.valueOf(false);
    public static String STATUS_NEVERRUN = "never_run";
    public static String STATUS_RUNNING = "running";
    public static String STATUS_INCOMPLETE = "incomplete";
    public static String STATUS_COMPLETE = "complete";
    public static String BUILD_SEQUENCE_STATUS_FINISH = "build_finish";
    public static String BUILD_SEQUENCE_STATUS_SCANNED = "build_sanned";
    private static Map<String, IndexBuildSequenceController> projectStatusMap = new HashMap<String, IndexBuildSequenceController>();
    private IProject project;
    private String runtimeBuildStatus;

    private IndexBuildSequenceController(IProject project) {
        this.project = project;
        this.intializeProjectStatus();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void intializeProjectStatus() {
        String index_after_build_option = null;
        String index_status = null;
        String build_status = null;
        try {
            index_after_build_option = this.project.getPersistentProperty(new QualifiedName("", INDEX_AFTER_BUILD_OPTION_KEY));
            index_status = this.project.getPersistentProperty(new QualifiedName("", INDEX_STATUS_KEY));
            build_status = this.project.getPersistentProperty(new QualifiedName("", BUILD_STATUS_KEY));
            if (index_after_build_option == null) {
                this.setIndexAfterBuildOption();
            }
            if (index_status == null) {
                this.project.setPersistentProperty(new QualifiedName("", INDEX_STATUS_KEY), STATUS_NEVERRUN);
            }
            if (build_status == null) {
                this.project.setPersistentProperty(new QualifiedName("", BUILD_STATUS_KEY), STATUS_NEVERRUN);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IndexBuildSequenceController getIndexBuildSequenceController(IProject p) {
        String projectName = p.getName();
        IndexBuildSequenceController ps = projectStatusMap.get(projectName);
        if (ps == null) {
            ps = new IndexBuildSequenceController(p);
            projectStatusMap.put(projectName, ps);
        }
        return ps;
    }

    public String getRuntimeBuildStatus() {
        return this.runtimeBuildStatus;
    }

    public void setFinalBuildStatus() {
        if (this.runtimeBuildStatus == null) {
            this.setBuildCompleted();
        } else if (this.runtimeBuildStatus.equals(STATUS_INCOMPLETE)) {
            this.setBuildInCompleted();
        }
        this.runtimeBuildStatus = null;
    }

    public void setRuntimeBuildStatus(String runtimeBuildStatus) {
        this.runtimeBuildStatus = runtimeBuildStatus;
    }

    public boolean checkStatus(String status_property_key, String expect_status) {
        String status = null;
        try {
            status = this.project.getPersistentProperty(new QualifiedName("", status_property_key));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (status != null) {
            return status.equals(expect_status);
        }
        return false;
    }

    public void setIndexAfterBuildOption() {
        this.setStatus(INDEX_AFTER_BUILD_OPTION_KEY, TRUE);
    }

    public void unsetIndexAfterBuildOption() {
        this.setStatus(INDEX_AFTER_BUILD_OPTION_KEY, FALSE);
    }

    public boolean isBuildServiceEnabled() {
        IService buildService = ServiceModelManager.getInstance().getService("org.eclipse.ptp.rdt.core.BuildService");
        IServiceConfiguration serviceConfig = ServiceModelManager.getInstance().getActiveConfiguration(this.project);
        return !serviceConfig.isDisabled(buildService);
    }

    public boolean isIndexAfterBuildSet() {
        return this.checkStatus(INDEX_AFTER_BUILD_OPTION_KEY, TRUE);
    }

    public boolean isIndexNeverRun() {
        return this.checkStatus(INDEX_STATUS_KEY, STATUS_NEVERRUN);
    }

    public boolean isIndexRunning() {
        return this.checkStatus(INDEX_STATUS_KEY, STATUS_RUNNING);
    }

    public boolean isIndexInCompleted() {
        return this.checkStatus(INDEX_STATUS_KEY, STATUS_INCOMPLETE);
    }

    public boolean isIndexCompleted() {
        return this.checkStatus(INDEX_STATUS_KEY, STATUS_COMPLETE);
    }

    public boolean isBuildNeverRun() {
        return this.checkStatus(BUILD_STATUS_KEY, STATUS_NEVERRUN);
    }

    public boolean isBuildRunning() {
        return this.checkStatus(BUILD_STATUS_KEY, STATUS_RUNNING);
    }

    public boolean isBuildInCompleted() {
        return this.checkStatus(BUILD_STATUS_KEY, STATUS_INCOMPLETE);
    }

    public boolean isBuildCompleted() {
        return this.checkStatus(BUILD_STATUS_KEY, STATUS_COMPLETE);
    }

    public void setIndexCompleted() {
        this.setStatus(INDEX_STATUS_KEY, STATUS_COMPLETE);
    }

    public void setIndexInCompleted() {
        this.setStatus(INDEX_STATUS_KEY, STATUS_INCOMPLETE);
    }

    public void setIndexRunning() {
        this.setStatus(INDEX_STATUS_KEY, STATUS_RUNNING);
    }

    public void setBuildCompleted() {
        this.setStatus(BUILD_STATUS_KEY, STATUS_COMPLETE);
    }

    public void setBuildInCompleted() {
        this.setStatus(BUILD_STATUS_KEY, STATUS_INCOMPLETE);
    }

    public void setBuildInCompletedForCleanBuild() {
        if (!this.isBuildNeverRun()) {
            this.setStatus(BUILD_STATUS_KEY, STATUS_INCOMPLETE);
        }
    }

    public void setBuildRunning() {
        this.setStatus(BUILD_STATUS_KEY, STATUS_RUNNING);
    }

    public void setStatus(String status_property_key, String status_to_set) {
        try {
            this.project.setPersistentProperty(new QualifiedName("", status_property_key), status_to_set);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean shouldRunIndexFollowingBuild() {
        return this.isBuildRunning();
    }

    public boolean shouldTurnIndexUpdateToReindex() {
        return this.isIndexNeverRun() && this.isBuildCompleted();
    }

    public boolean shouldSkipIndexUpdate() {
        if (this.isBuildRunning()) {
            return true;
        }
        if (this.isIndexNeverRun()) {
            return !this.isBuildCompleted();
        }
        return false;
    }

    public boolean shouldSkipReindex() {
        if (this.isBuildRunning()) {
            return true;
        }
        return this.isBuildNeverRun() && this.isIndexNeverRun();
    }

    public boolean isOptionalIndex() {
        return !this.isBuildCompleted();
    }

    public void invokeIndex() {
        Job job = new Job("Indexing Job"){

            protected IStatus run(IProgressMonitor monitor) {
                if (IndexBuildSequenceController.this.shouldRunIndexFollowingBuild()) {
                    IndexBuildSequenceController.this.setFinalBuildStatus();
                    if (IndexBuildSequenceController.this.isBuildCompleted()) {
                        ICProject cProject = CModelManager.getDefault().getCModel().getCProject((IResource)IndexBuildSequenceController.this.project);
                        CCorePlugin.getIndexManager().reindex(cProject);
                    }
                } else {
                    IndexBuildSequenceController.this.setFinalBuildStatus();
                }
                return Status.OK_STATUS;
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        job.setRule((ISchedulingRule)rule);
        job.schedule();
    }

    private void deleteProjectStaus(String projectName) {
        projectStatusMap.remove(projectName);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            if (event.getType() == 4 && resource.getType() == 4 && RemoteNature.hasRemoteNature((IProject)resource)) {
                this.deleteProjectStaus(resource.getName());
            }
        }
    }
}

