/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.ASTFilePathResolver;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.YieldableIndexLock;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritablePDOM
extends PDOM
implements IWritableIndexFragment {
    private boolean fClearedBecauseOfVersionMismatch = false;
    private boolean fCreatedFromScratch = false;
    private ASTFilePathResolver fPathResolver;
    private PDOMFile fileBeingUpdated;
    private PDOMFile uncommittedFile;
    private IIndexFileLocation uncommittedLocation;

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map<String, IPDOMLinkageFactory> linkageFactoryMappings) throws CoreException {
        super(dbPath, locationConverter, cache, linkageFactoryMappings);
    }

    public void setASTFilePathResolver(ASTFilePathResolver resolver) {
        this.fPathResolver = resolver;
    }

    @Override
    public IIndexFragmentFile addFile(int linkageID, IIndexFileLocation location) throws CoreException {
        if (this.uncommittedLocation != null && this.uncommittedLocation.equals(location)) {
            return this.uncommittedFile;
        }
        return super.addFile(linkageID, location);
    }

    @Override
    public IIndexFragmentFile addUncommittedFile(int linkageID, IIndexFileLocation location) throws CoreException {
        this.uncommittedLocation = location;
        this.fileBeingUpdated = this.getFile(linkageID, this.uncommittedLocation);
        PDOMLinkage linkage = this.createLinkage(linkageID);
        this.uncommittedFile = new PDOMFile(linkage, location, linkageID);
        return this.uncommittedFile;
    }

    @Override
    public IIndexFragmentFile commitUncommittedFile() throws CoreException {
        PDOMFile file;
        if (this.uncommittedFile == null) {
            return null;
        }
        if (this.fileBeingUpdated == null) {
            BTree fileIndex = this.getFileIndex();
            fileIndex.insert(this.uncommittedFile.getRecord());
            file = this.uncommittedFile;
        } else {
            this.fileBeingUpdated.replaceContentsFrom(this.uncommittedFile);
            file = this.fileBeingUpdated;
            this.fileBeingUpdated = null;
        }
        this.fEvent.fFilesWritten.add(this.uncommittedLocation);
        this.uncommittedFile = null;
        this.uncommittedLocation = null;
        return file;
    }

    @Override
    public void clearUncommittedFile() throws CoreException {
        if (this.uncommittedFile != null) {
            try {
                this.uncommittedFile.clear(null);
                this.uncommittedFile.delete();
            }
            finally {
                this.uncommittedFile = null;
                this.uncommittedLocation = null;
                this.fileBeingUpdated = null;
            }
        }
    }

    @Override
    public void addFileContent(IIndexFragmentFile sourceFile, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorStatement[] macros, IASTName[][] names, ASTFilePathResolver pathResolver, YieldableIndexLock lock) throws CoreException, InterruptedException {
        assert (sourceFile.getIndexFragment() == this);
        PDOMFile pdomFile = (PDOMFile)sourceFile;
        pdomFile.addIncludesTo(includes);
        pdomFile.addMacros(macros);
        ASTFilePathResolver origResolver = this.fPathResolver;
        this.fPathResolver = pathResolver;
        try {
            pdomFile.addNames(names, lock);
        }
        finally {
            this.fPathResolver = origResolver;
        }
        IIndexFileLocation location = pdomFile.getLocation();
        if (location != null) {
            this.fEvent.fClearedFiles.remove(location);
            this.fEvent.fFilesWritten.add(location);
        }
    }

    @Override
    public void clearFile(IIndexFragmentFile file, Collection<IIndexFileLocation> contextsRemoved) throws CoreException {
        assert (file.getIndexFragment() == this);
        ((PDOMFile)file).clear(contextsRemoved);
        this.fEvent.fClearedFiles.add(file.getLocation());
    }

    @Override
    public void clear() throws CoreException {
        super.clear();
    }

    @Override
    public void flush() throws CoreException {
        super.flush();
    }

    @Override
    public void setProperty(String propertyName, String value) throws CoreException {
        if ("org.eclipse.cdt.internal.core.index.fragment.format.id".equals(propertyName) || "org.eclipse.cdt.internal.core.index.fragment.format.version".equals(propertyName)) {
            throw new IllegalArgumentException("Property " + value + " may not be written to");
        }
        new DBProperties(this.db, 2056L).setProperty(propertyName, value);
    }

    public void rewriteLocations(IIndexLocationConverter newConverter) throws CoreException {
        final ArrayList pdomfiles = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            public int compare(long record) throws CoreException {
                return 0;
            }

            public boolean visit(long record) throws CoreException {
                PDOMFile file = PDOMFile.recreateFile(WritablePDOM.this, record);
                pdomfiles.add(file);
                return true;
            }
        });
        this.clearFileIndex();
        ArrayList<PDOMFile> notConverted = new ArrayList<PDOMFile>();
        for (PDOMFile file : pdomfiles) {
            String internalFormat = newConverter.toInternalFormat(file.getLocation());
            if (internalFormat != null) {
                file.setInternalLocation(internalFormat);
                this.getFileIndex().insert(file.getRecord());
                continue;
            }
            notConverted.add(file);
        }
        for (PDOMFile file : notConverted) {
            file.convertIncludersToUnresolved();
            file.clear(null);
        }
    }

    boolean isClearedBecauseOfVersionMismatch() {
        return this.fClearedBecauseOfVersionMismatch;
    }

    void setClearedBecauseOfVersionMismatch(boolean clearedBecauseOfVersionMismatch) {
        this.fClearedBecauseOfVersionMismatch = clearedBecauseOfVersionMismatch;
    }

    boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    void setCreatedFromScratch(boolean createdFromScratch) {
        this.fCreatedFromScratch = createdFromScratch;
    }

    @Override
    protected final boolean isPermanentlyReadOnly() {
        return false;
    }

    public PDOMFile getFileForASTPath(int linkageID, String astPath) throws CoreException {
        if (this.fPathResolver != null && astPath != null) {
            IIndexFileLocation location = this.fPathResolver.resolveASTPath(astPath);
            if (location.equals(this.uncommittedLocation)) {
                return this.fileBeingUpdated != null ? this.fileBeingUpdated : this.uncommittedFile;
            }
            return this.getFile(linkageID, location);
        }
        return null;
    }

    @Override
    public boolean hasLastingDefinition(PDOMBinding binding) throws CoreException {
        if (this.fileBeingUpdated == null) {
            return binding.hasDefinition();
        }
        PDOMName name = binding.getFirstDefinition();
        while (name != null) {
            if (!this.fileBeingUpdated.getPDOM().equals(name.getPDOM()) || this.fileBeingUpdated.getRecord() != name.getFileRecord()) {
                return true;
            }
            name = name.getNextInBinding();
        }
        return false;
    }

    @Override
    protected boolean isCommitted(PDOMName name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    protected boolean isCommitted(PDOMMacro name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    protected boolean isCommitted(PDOMMacroReferenceName name) throws CoreException {
        return this.uncommittedFile == null || !this.uncommittedFile.getPDOM().equals(name.getPDOM()) || this.uncommittedFile.getRecord() != name.getFileRecord();
    }

    @Override
    public long getDatabaseSizeBytes() {
        return this.getDB().getSizeBytes();
    }
}

