/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.pbs.core.rmsystem.IPBSResourceManagerConfiguration;
import org.eclipse.ptp.rm.pbs.core.rmsystem.PBSResourceManager;
import org.eclipse.ptp.rm.pbs.ui.data.AttributePlaceholder;
import org.eclipse.ptp.rm.pbs.ui.data.PBSBatchScriptTemplate;
import org.eclipse.ptp.rm.pbs.ui.dialogs.ScrollingEditableMessageDialog;
import org.eclipse.ptp.rm.pbs.ui.managers.PBSBatchScriptTemplateManager;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.rm.pbs.ui.utils.WidgetUtils;
import org.eclipse.ptp.rm.pbs.ui.wizards.PBSRMLaunchConfigurationDynamicTabWizardPage;
import org.eclipse.ptp.rm.ui.launch.BaseRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabDataSource;
import org.eclipse.ptp.rm.ui.launch.RMLaunchConfigurationDynamicTabWidgetListener;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.utils.WidgetListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSRMLaunchConfigurationDynamicTab
extends BaseRMLaunchConfigurationDynamicTab {
    private static final Map<String, ILaunchConfiguration> configurations = new HashMap<String, ILaunchConfiguration>();
    private static final String[] mpiChoices = Messages.MPICommands.split(",");
    private static final String TAG_CURRENT_TEMPLATE = Messages.PBSRMLaunchConfigCurrentTemplate;
    private IPQueue[] queues;
    private ScrolledComposite parent;
    private Composite childControl;
    private Composite control;
    private PBSRMLaunchDataSource dataSource;
    private Button editPostpended;
    private Button editPrepended;
    private PBSRMLaunchWidgetListener listener;
    private Combo mpiCommand;
    private TemplateChangeListener templateChangeListener;
    private PBSBatchScriptTemplateManager templateManager;
    private Combo templates;
    private Map<Control, AttributePlaceholder> valueWidgets;
    private Button viewScript;

    public PBSRMLaunchConfigurationDynamicTab(IResourceManager resourceManager) {
        try {
            this.templateChangeListener = new TemplateChangeListener();
            this.templateManager = new PBSBatchScriptTemplateManager();
            this.valueWidgets = new HashMap<Control, AttributePlaceholder>();
            this.templateManager.loadTemplate(null, null);
            this.queues = resourceManager.getQueues();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) throws CoreException {
        if (parent instanceof ScrolledComposite) {
            this.parent = (ScrolledComposite)parent;
        }
        this.control = WidgetUtils.createComposite(parent, 2);
        this.populateControl();
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration, String mode) throws CoreException {
        ArrayList attrs = new ArrayList();
        String current = configuration.getAttribute(TAG_CURRENT_TEMPLATE, "");
        PBSBatchScriptTemplate template = this.templateManager.loadTemplate(current, configuration);
        try {
            template.configure();
            attrs.add(this.templateManager.getCurrent().createScriptAttribute());
        }
        catch (IllegalValueException t) {
            Status status = new Status(4, "org.eclipse.ptp.rm.pbs.ui", "getAttributes", (Throwable)t);
            throw new CoreException((IStatus)status);
        }
        return attrs.toArray(new IAttribute[attrs.size()]);
    }

    public Control getControl() {
        return this.control;
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return Messages.PBSConfigurationWizardPage_title;
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        this.dataSource.currentConfigName = configuration.getName();
        String oldRM = this.dataSource.lastRMId;
        RMLaunchValidation rmv = super.performApply(configuration, rm, queue);
        if (this.templateChangeListener.isEnabled() && oldRM == null) {
            PBSResourceManager pbsRM = (PBSResourceManager)rm;
            IPBSResourceManagerConfiguration rmConfig = (IPBSResourceManagerConfiguration)pbsRM.getConfiguration();
            this.dataSource.defaultTemplate = rmConfig.getDefaultTemplateName();
            this.dataSource.setCurrentTemplate(oldRM);
            this.fireTemplateChange();
        }
        this.dataSource.setCurrentConfiguration();
        return rmv;
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        return new RMLaunchValidation(true, null);
    }

    public void updateControls() {
    }

    protected synchronized RMLaunchConfigurationDynamicTabDataSource createDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new PBSRMLaunchDataSource(this);
        }
        return this.dataSource;
    }

    protected synchronized RMLaunchConfigurationDynamicTabWidgetListener createListener() {
        if (this.listener == null) {
            this.listener = new PBSRMLaunchWidgetListener(this);
        }
        return this.listener;
    }

    private void createOptionalGroup(Composite parent, PBSBatchScriptTemplate template) {
        if (template == null) {
            return;
        }
        boolean[] nonNull = new boolean[]{template.getMpiCommand() != null, template.getPrependedBashCommands() != null, template.getPostpendedBashCommands() != null};
        if (!(nonNull[0] || nonNull[1] || nonNull[2])) {
            return;
        }
        Group options = WidgetUtils.createFillingGroup(parent, Messages.PBSRMLaunchConfigGroup2_title, 3, 1, false);
        options.setForeground(WidgetUtils.DKMG);
        if (nonNull[0]) {
            this.mpiCommand = WidgetUtils.createItemCombo((Composite)options, Messages.PBSBatchScriptTemplateMPICommand, mpiChoices, mpiChoices[0], null, true, (ModifyListener)this.listener, 2);
        }
        if (nonNull[1]) {
            this.editPrepended = WidgetUtils.createButton((Composite)options, Messages.PBSBatchScriptTemplateEditPrepend_title, null, 8, 1, false, (SelectionListener)this.listener);
        }
        if (nonNull[2]) {
            this.editPostpended = WidgetUtils.createButton((Composite)options, Messages.PBSBatchScriptTemplateEditPostpend_title, null, 8, 1, false, (SelectionListener)this.listener);
        }
    }

    private void createSelectionGroup(Composite parent) {
        Group selection = WidgetUtils.createFillingGroup(parent, Messages.PBSRMLaunchConfigGroup1_title, 3, 3, true);
        selection.setForeground(WidgetUtils.DKMG);
        this.templates = WidgetUtils.createItemCombo((Composite)selection, null, this.templateManager.findAvailableTemplates(), null, null, true, (ModifyListener)this.templateChangeListener, 2);
        ((GridData)this.templates.getLayoutData()).widthHint = 200;
        this.viewScript = WidgetUtils.createButton((Composite)selection, Messages.PBSRMLaunchConfigViewScript_title, null, 8, 1, true, (SelectionListener)this.listener);
    }

    private void fireTemplateChange() {
        new UIJob("template change"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    try {
                        PBSRMLaunchConfigurationDynamicTab.this.templateChangeListener.disable();
                        PBSRMLaunchConfigurationDynamicTab.this.dataSource.copyFromFields();
                        PBSRMLaunchConfigurationDynamicTab.this.dataSource.copyToStorage();
                        ILaunchConfiguration c = PBSRMLaunchConfigurationDynamicTab.get(PBSRMLaunchConfigurationDynamicTab.this.dataSource.currentConfigName);
                        PBSRMLaunchConfigurationDynamicTab.this.templateManager.loadTemplate(PBSRMLaunchConfigurationDynamicTab.this.dataSource.currentTemplate, c);
                        PBSRMLaunchConfigurationDynamicTab.this.populateControl();
                        PBSRMLaunchConfigurationDynamicTab.this.dataSource.loadFromStorage();
                        PBSRMLaunchConfigurationDynamicTab.this.dataSource.copyToFields();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        PBSRMLaunchConfigurationDynamicTab.this.templateChangeListener.enable();
                    }
                }
                finally {
                    PBSRMLaunchConfigurationDynamicTab.this.templateChangeListener.enable();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void maybeSetQueues() {
        if (this.queues == null || this.queues.length == 0) {
            return;
        }
        for (Map.Entry<Control, AttributePlaceholder> e : this.valueWidgets.entrySet()) {
            AttributePlaceholder ap = e.getValue();
            String name = ap.getName();
            if (!name.equals("destination")) continue;
            Combo combo = (Combo)e.getKey();
            ArrayList<String> queueNames = new ArrayList<String>();
            IPQueue[] iPQueueArray = this.queues;
            int n = this.queues.length;
            int n2 = 0;
            while (n2 < n) {
                IPQueue q = iPQueueArray[n2];
                String qname = q.getName();
                if (qname.length() > 0) {
                    queueNames.add(qname);
                }
                ++n2;
            }
            String value = ap.getAttribute().getValueAsString();
            if (value == null || value.length() == 0) {
                try {
                    ap.getAttribute().setValueAsString((String)queueNames.get(0));
                }
                catch (IllegalValueException t) {
                    t.printStackTrace();
                }
            }
            combo.setItems(queueNames.toArray(new String[0]));
        }
    }

    private void populateControl() {
        if (this.childControl != null) {
            this.childControl.dispose();
            this.valueWidgets.clear();
        }
        this.childControl = WidgetUtils.createComposite(this.control, 1);
        this.createSelectionGroup(this.childControl);
        PBSBatchScriptTemplate template = this.templateManager.getCurrent();
        if (template != null) {
            this.createOptionalGroup(this.childControl, template);
            PBSRMLaunchConfigurationDynamicTabWizardPage wizardPage = new PBSRMLaunchConfigurationDynamicTabWizardPage(this.valueWidgets, this.getListener(), template);
            wizardPage.createControl(this.childControl);
            this.maybeSetQueues();
        }
        if (this.parent != null) {
            this.parent.setMinSize(this.control.computeSize(-1, -1));
        }
    }

    private static synchronized ILaunchConfiguration get(String name) {
        return configurations.get(name);
    }

    private static synchronized void put(ILaunchConfiguration configuration) {
        configurations.put(configuration.getName(), configuration);
    }

    private class PBSRMLaunchDataSource
    extends RMLaunchConfigurationDynamicTabDataSource {
        private String currentConfigName;
        private String currentRMId;
        private String currentTemplate;
        private String defaultTemplate;
        private String lastRMId;

        protected PBSRMLaunchDataSource(BaseRMLaunchConfigurationDynamicTab page) {
            super(page);
        }

        public void setResourceManager(IResourceManager rm) {
            this.lastRMId = this.currentRMId;
            this.currentRMId = rm.getResourceManagerId();
            super.setResourceManager(rm);
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            PBSBatchScriptTemplate template = PBSRMLaunchConfigurationDynamicTab.this.templateManager.getCurrent();
            if (template == null) {
                return;
            }
            AttributePlaceholder ap = null;
            Object value = null;
            for (Map.Entry e : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.entrySet()) {
                Control c = (Control)e.getKey();
                ap = (AttributePlaceholder)e.getValue();
                value = null;
                if (c instanceof Text) {
                    value = ((Text)c).getText();
                } else if (c instanceof Combo) {
                    value = ((Combo)c).getText();
                } else if (c instanceof Spinner) {
                    value = ((Spinner)c).getSelection();
                } else if (c instanceof Button) {
                    value = ((Button)c).getSelection();
                }
                try {
                    ap.getAttribute().setValueAsString(value.toString());
                }
                catch (IllegalValueException t) {
                    throw new DataSource.ValidationException((DataSource)this, t.toString());
                }
            }
            if (PBSRMLaunchConfigurationDynamicTab.this.templateChangeListener.isEnabled() && PBSRMLaunchConfigurationDynamicTab.this.mpiCommand != null) {
                value = PBSRMLaunchConfigurationDynamicTab.this.mpiCommand.getText().trim();
                try {
                    template.setMPIAttributes((String)value);
                }
                catch (IllegalValueException t) {
                    throw new DataSource.ValidationException((DataSource)this, String.valueOf(t.getMessage()) + ": " + t.getCause());
                }
            }
        }

        protected void copyToFields() {
            String[] items;
            PBSBatchScriptTemplate template = PBSRMLaunchConfigurationDynamicTab.this.templateManager.getCurrent();
            if (template == null) {
                return;
            }
            AttributePlaceholder ap = null;
            IAttribute<?, ?, ?> attr = null;
            Object value = null;
            for (Map.Entry e : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.entrySet()) {
                ap = (AttributePlaceholder)e.getValue();
                attr = ap.getAttribute();
                if (attr != null) {
                    value = attr.getValue();
                }
                Control c = (Control)e.getKey();
                if (value == null) continue;
                if (c instanceof Text) {
                    this.applyText((Text)c, (String)value);
                    continue;
                }
                if (c instanceof Combo) {
                    this.applyText((Combo)c, (String)value);
                    continue;
                }
                if (c instanceof Spinner) {
                    ((Spinner)c).setSelection(((Integer)value).intValue());
                    continue;
                }
                if (!(c instanceof Button)) continue;
                ((Button)c).setSelection(((Boolean)value).booleanValue());
            }
            ap = template.getMpiCommand();
            if (ap != null) {
                attr = ap.getAttribute();
                if (attr != null) {
                    value = attr.getValue();
                }
                if (value != null) {
                    items = PBSRMLaunchConfigurationDynamicTab.this.mpiCommand.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(value)) {
                            PBSRMLaunchConfigurationDynamicTab.this.mpiCommand.select(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            items = PBSRMLaunchConfigurationDynamicTab.this.templates.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(this.currentTemplate)) {
                    PBSRMLaunchConfigurationDynamicTab.this.templates.select(i);
                    break;
                }
                ++i;
            }
        }

        protected void copyToStorage() {
            ILaunchConfigurationWorkingCopy config = this.getConfigurationWorkingCopy();
            if (config == null) {
                return;
            }
            config.setAttribute(TAG_CURRENT_TEMPLATE, this.currentTemplate);
            PBSBatchScriptTemplate template = PBSRMLaunchConfigurationDynamicTab.this.templateManager.getCurrent();
            if (template != null) {
                template.saveValues(config);
            }
        }

        protected void loadDefault() {
        }

        protected void loadFromStorage() {
            ILaunchConfiguration config = this.getConfiguration();
            if (config != null) {
                PBSBatchScriptTemplate template = PBSRMLaunchConfigurationDynamicTab.this.templateManager.getCurrent();
                if (template == null) {
                    return;
                }
                template.setConfiguration(config);
                try {
                    template.configure();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        protected void validateLocal() throws DataSource.ValidationException {
            for (Control c : PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.keySet()) {
                AttributePlaceholder ap;
                String value;
                if (c instanceof Text) {
                    Text t = (Text)c;
                    value = t.getText().trim();
                    ap = (AttributePlaceholder)PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.get(c);
                    String defaultString = ap.getDefaultString();
                    if (!"".equals(value) || "".equals(defaultString)) continue;
                    t.setText(defaultString);
                    continue;
                }
                if (!(c instanceof Combo)) continue;
                Combo cmb = (Combo)c;
                value = cmb.getText();
                ap = (AttributePlaceholder)PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.get(c);
                if (value.indexOf("?") < 0) continue;
                throw new DataSource.ValidationException((DataSource)this, String.valueOf(ap.getName()) + ": " + Messages.PBSRMLaunchDataSource_ValueNotSet);
            }
        }

        private void setCurrentConfiguration() {
            ILaunchConfigurationWorkingCopy config = this.getConfigurationWorkingCopy();
            if (config == null) {
                return;
            }
            PBSRMLaunchConfigurationDynamicTab.put((ILaunchConfiguration)config);
        }

        private void setCurrentTemplate(String oldRM) {
            try {
                ILaunchConfiguration c = PBSRMLaunchConfigurationDynamicTab.get(this.currentConfigName);
                this.currentTemplate = c == null ? this.defaultTemplate : c.getAttribute(TAG_CURRENT_TEMPLATE, this.defaultTemplate);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
    }

    private class PBSRMLaunchWidgetListener
    extends RMLaunchConfigurationDynamicTabWidgetListener {
        public PBSRMLaunchWidgetListener(BaseRMLaunchConfigurationDynamicTab dynamicTab) {
            super(dynamicTab);
        }

        public void modifyText(ModifyEvent e) {
            Object o = e.getSource();
            if (!PBSRMLaunchConfigurationDynamicTab.this.templateChangeListener.isEnabled() && PBSRMLaunchConfigurationDynamicTab.this.valueWidgets.containsKey(o)) {
                return;
            }
            super.modifyText(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o == PBSRMLaunchConfigurationDynamicTab.this.editPrepended || o == PBSRMLaunchConfigurationDynamicTab.this.editPostpended || o == PBSRMLaunchConfigurationDynamicTab.this.viewScript) {
                this.widgetSelected(e);
            } else {
                super.widgetDefaultSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            PBSBatchScriptTemplate template = PBSRMLaunchConfigurationDynamicTab.this.templateManager.getCurrent();
            if (template == null) {
                return;
            }
            AttributePlaceholder ap = null;
            Object o = e.getSource();
            String title = "";
            if (o == PBSRMLaunchConfigurationDynamicTab.this.editPrepended) {
                title = Messages.PBSBatchScriptTemplateEditPrepend_title;
                ap = template.getPrependedBashCommands();
            } else if (o == PBSRMLaunchConfigurationDynamicTab.this.editPostpended) {
                title = Messages.PBSBatchScriptTemplateEditPostpend_title;
                ap = template.getPostpendedBashCommands();
            }
            try {
                if (ap != null) {
                    this.openEditor(ap, title);
                } else if (o == PBSRMLaunchConfigurationDynamicTab.this.viewScript) {
                    this.openReadOnly(template.realize());
                    super.widgetSelected(e);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private void openEditor(AttributePlaceholder ap, String title) {
            try {
                IAttribute<?, ?, ?> attr = ap.getAttribute();
                String attrval = attr.getValueAsString();
                ScrollingEditableMessageDialog dialog = new ScrollingEditableMessageDialog(PBSRMLaunchConfigurationDynamicTab.this.control.getShell(), title, attrval);
                if (dialog.open() == 1) {
                    return;
                }
                attr.setValueAsString(dialog.getValue());
            }
            catch (Throwable t) {
                WidgetUtils.errorMessage(PBSRMLaunchConfigurationDynamicTab.this.control.getShell(), t, Messages.PBSBatchScriptTemplateEditError_message, Messages.PBSBatchScriptTemplateEditError_title, false);
            }
        }

        private void openReadOnly(String script) {
            try {
                new ScrollingEditableMessageDialog(PBSRMLaunchConfigurationDynamicTab.this.control.getShell(), Messages.PBSBatchScriptDislay, script, true).open();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class TemplateChangeListener
    extends WidgetListener {
        private TemplateChangeListener() {
        }

        protected void doModifyText(ModifyEvent e) {
            PBSRMLaunchConfigurationDynamicTab.this.dataSource.currentTemplate = PBSRMLaunchConfigurationDynamicTab.this.templates.getItem(PBSRMLaunchConfigurationDynamicTab.this.templates.getSelectionIndex());
            PBSRMLaunchConfigurationDynamicTab.this.fireTemplateChange();
        }
    }
}

