/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.feedback.views;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.etfw.feedback.Activator;
import org.eclipse.ptp.etfw.feedback.messages.Messages;
import org.eclipse.ptp.etfw.feedback.views.SimpleTreeTableMarkerView;

public class FeedbackTreeTableMarkerView
extends SimpleTreeTableMarkerView {
    private static boolean CREATE_PARENT_NODES = false;
    private static String[] attrNames = new String[]{"name", "filename", "functionCaller", "functionCallee", "lineNumber", "description", "LoopId"};
    private static String[] colNames;
    private static int[] widths;
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    protected boolean maintainExpandCollapseState = this.preferenceStore.getBoolean("maintainExpandCollapseState");

    static {
        widths = new int[]{160, 100, 100, 100, 80, 200, 60};
    }

    public FeedbackTreeTableMarkerView(Activator plugin, String markerID) {
        super(plugin, "XForm", "XForms", attrNames, colNames, widths, markerID, "parent", CREATE_PARENT_NODES);
    }

    public String extractMarkerInfo(IMarker marker) {
        StringBuffer infoBuffer = new StringBuffer();
        String filename = marker.getResource().getName();
        String name = this.getStrAttr(marker, "name");
        infoBuffer.append(Messages.FeedbackTreeTableMarkerView_fileName).append(filename);
        infoBuffer.append(Messages.FeedbackTreeTableMarkerView_lineNumber).append(this.getStrAttr(marker, "lineNumber"));
        infoBuffer.append(Messages.FeedbackTreeTableMarkerView_name).append(name);
        String parent = this.getStrAttr(marker, "parent");
        infoBuffer.append(Messages.FeedbackTreeTableMarkerView_parentItemType).append(parent);
        infoBuffer.append(Messages.FeedbackTreeTableMarkerView_description).append(this.getStrAttr(marker, "description"));
        return infoBuffer.toString();
    }

    public String getStrAttr(IMarker marker, String attrName) {
        try {
            String str = marker.getAttribute(attrName).toString();
            return str;
        }
        catch (CoreException e) {
            System.out.println("Exception getting marker attr in CompilerXFormTreeTableView.getStrAttr() " + e.getMessage());
            return "*error*";
        }
    }

    public String removeSpaces(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", false);
        String t = "";
        while (st.hasMoreElements()) {
            t = String.valueOf(t) + st.nextElement();
        }
        return t;
    }

    protected void maintainExpandCollapseStatus() {
        this.maintainExpandCollapseState = this.preferenceStore.getBoolean("maintainExpandCollapseState");
        if (this.maintainExpandCollapseState) {
            switch (this.expandCollapseStatus) {
                case 1: {
                    this.expandAllAction.run();
                    break;
                }
                case 2: {
                    this.collapseAllAction.run();
                }
            }
        }
    }
}

