/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ptp.internal.rdt.ui.actions.OpenViewActionGroup;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCContentOutlinePage;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCEditorHelpContextProvider;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteCSourceViewerConfiguration;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionSearchGroup;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteCEditor
extends CEditor {
    private IEditorInput input;

    public RemoteCEditor() {
        this.setEditorContextMenuId("#RemoteCEditorContext");
        this.setRulerContextMenuId("#RemoteCEditorRulerContext");
        this.setOutlinerContextMenuId("#RemoteCEditorOutlinerContext");
    }

    private boolean isRemote() {
        ICElement element = this.getInputCElement();
        if (element == null) {
            return false;
        }
        ICProject cProject = element.getCProject();
        if (cProject == null) {
            return false;
        }
        IProject project = cProject.getProject();
        return RemoteNature.hasRemoteNature((IProject)project);
    }

    protected ActionGroup createSelectionSearchGroup() {
        return this.isRemote() ? new SelectionSearchGroup(this) : super.createSelectionSearchGroup();
    }

    protected ActionGroup createOpenViewActionGroup() {
        return this.isRemote() ? new OpenViewActionGroup((ITextEditor)this) : super.createOpenViewActionGroup();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ptp.rdt.ui.remote_C_CPP_editor_context");
    }

    public Object getAdapter(Class required) {
        if (IContextProvider.class.equals((Object)required)) {
            return new RemoteCEditorHelpContextProvider((ITextEditor)this);
        }
        return super.getAdapter(required);
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.isRemote()) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new RemoteCContentOutlinePage(this);
                this.fOutlinePage.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            RemoteCEditor.setOutlinePageInput((CContentOutlinePage)this.fOutlinePage, (IEditorInput)this.getEditorInput());
            return this.fOutlinePage;
        }
        return super.getOutlinePage();
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        SourceViewerConfiguration sourceViewerConfiguration;
        IProject project;
        super.setPreferenceStore(store);
        ICProject cproject = EditorUtility.getCProject((IEditorInput)this.input);
        if (cproject != null && RemoteNature.hasRemoteNature((IProject)(project = cproject.getProject())) && !((sourceViewerConfiguration = this.getSourceViewerConfiguration()) instanceof RemoteCSourceViewerConfiguration)) {
            CTextTools textTools = CUIPlugin.getDefault().getTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new RemoteCSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___c_partitioning"));
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.input = input;
        super.doSetInput(input);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.remove("org.eclipse.search.text.ctxmenu");
        menu.remove("org.eclipse.cdt.ui.refactoring.menu");
    }

    public boolean shouldProcessLocalParsingCompletions() {
        ICProject cproject = EditorUtility.getCProject((IEditorInput)this.input);
        return !RemoteNature.hasRemoteNature((IProject)cproject.getProject());
    }
}

