/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.internal.core.parser.CodeReaderLRUCache;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.FileCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.resources.PathCanonicalizationStrategy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InternalParserUtil
extends ParserFactory {
    private static final String SYSTEM_DEFAULT_ENCODING = System.getProperty("file.encoding");

    public static String normalizePath(String path, IFile file) {
        IPath loc = file.getLocation();
        if (loc != null) {
            path = loc.toOSString();
        }
        return path;
    }

    @Deprecated
    public static CodeReader createExternalFileReader(String externalLocation, CodeReaderLRUCache cache) throws IOException {
        File includeFile = new File(externalLocation);
        if (includeFile.isFile()) {
            CodeReader result;
            String path = PathCanonicalizationStrategy.getCanonicalPath(includeFile);
            if (cache != null && (result = cache.get(path)) != null) {
                return result;
            }
            return new CodeReader(path);
        }
        return null;
    }

    @Deprecated
    public static CodeReader createWorkspaceFileReader(String path, IFile file, CodeReaderLRUCache cache) throws CoreException, IOException {
        CodeReader codeReader;
        InputStream in;
        CodeReader result;
        path = InternalParserUtil.normalizePath(path, file);
        if (cache != null && (result = cache.get(path)) != null) {
            return result;
        }
        try {
            in = file.getContents(true);
        }
        catch (CoreException e) {
            switch (e.getStatus().getCode()) {
                case 269: 
                case 270: 
                case 271: 
                case 369: {
                    return null;
                }
            }
            throw e;
        }
        try {
            codeReader = new CodeReader(path, file.getCharset(), in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return codeReader;
    }

    @Deprecated
    public static CodeReader createCodeReader(IIndexFileLocation ifl, CodeReaderLRUCache cache) throws CoreException, IOException {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            return InternalParserUtil.createWorkspaceFileReader(ifl.getURI().getPath(), (IFile)res, cache);
        }
        return InternalParserUtil.createExternalFileReader(ifl.getURI().getPath(), cache);
    }

    public static InternalFileContent createFileContent(IIndexFileLocation ifl) {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            return InternalParserUtil.createWorkspaceFileContent((IFile)res);
        }
        return InternalParserUtil.createExternalFileContent(ifl.getURI().getPath());
    }

    public static InternalFileContent createWorkspaceFileContent(IFile file) {
        InternalFileContent internalFileContent;
        String path = file.getLocationURI().getPath();
        path = InternalParserUtil.normalizePath(path, file);
        InputStream in = file.getContents(true);
        try {
            internalFileContent = InternalParserUtil.createFileContent(path, file.getCharset(), in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (CoreException e) {
                switch (e.getStatus().getCode()) {
                    case 269: 
                    case 270: 
                    case 271: 
                    case 369: {
                        break;
                    }
                    default: {
                        CCorePlugin.log((Throwable)e);
                    }
                }
                return null;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return internalFileContent;
    }

    public static InternalFileContent createExternalFileContent(String externalLocation) {
        File includeFile = new File(externalLocation);
        if (includeFile.isFile()) {
            InternalFileContent internalFileContent;
            FileInputStream in;
            String path = PathCanonicalizationStrategy.getCanonicalPath(includeFile);
            try {
                in = new FileInputStream(includeFile);
            }
            catch (IOException e) {
                CCorePlugin.log((Throwable)e);
                return null;
            }
            try {
                internalFileContent = InternalParserUtil.createFileContent(path, SYSTEM_DEFAULT_ENCODING, in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return internalFileContent;
        }
        return null;
    }

    private static InternalFileContent createFileContent(String path, String charset, InputStream in) {
        try {
            AbstractCharArray chars = FileCharArray.create(path, charset, in);
            return new InternalFileContent(path, chars);
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }
}

