/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMValue {
    public static long store(Database db, PDOMLinkage linkage, IValue val) throws CoreException {
        if (val == null) {
            return 0L;
        }
        IBinding[] unknown = val.getUnknownBindings();
        long[] unknownRecs = new long[]{};
        if (unknown.length != 0) {
            unknownRecs = new long[unknown.length];
            int i = 0;
            while (i < unknown.length) {
                PDOMBinding node = linkage.addUnknownValue(unknown[i]);
                if (node == null) {
                    return PDOMValue.store(db, linkage, Value.UNKNOWN);
                }
                unknownRecs[i] = node.getRecord();
                ++i;
            }
        }
        int len = Math.min(unknown.length, 1022);
        long block = db.malloc(6 + 4 * len);
        long repRec = db.newString(val.getInternalExpression()).getRecord();
        db.putShort(block, (short)len);
        db.putRecPtr(block + 2L, repRec);
        long p = block + 6L;
        int i = 0;
        while (i < len) {
            db.putRecPtr(p, unknownRecs[i]);
            p += 4L;
            ++i;
        }
        return block;
    }

    public static IValue restore(Database db, PDOMLinkage linkage, long valRec) throws CoreException {
        if (valRec == 0L) {
            return null;
        }
        short len = db.getShort(valRec);
        long repRec = db.getRecPtr(valRec + 2L);
        char[] rep = db.getString(repRec).getChars();
        if (len == 0) {
            return Value.fromInternalRepresentation(rep, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
        }
        ICPPUnknownBinding[] unknown = new ICPPUnknownBinding[len];
        long p = valRec + 6L;
        int i = 0;
        while (i < unknown.length) {
            long rec = db.getRecPtr(p);
            PDOMNode node = linkage.getNode(rec);
            if (!(node instanceof ICPPUnknownBinding)) {
                return Value.UNKNOWN;
            }
            unknown[i] = (ICPPUnknownBinding)((Object)node);
            p += 4L;
            ++i;
        }
        return Value.fromInternalRepresentation(rep, unknown);
    }

    public static void delete(Database db, long valueRec) throws CoreException {
        if (valueRec == 0L) {
            return;
        }
        long repRec = db.getRecPtr(valueRec + 2L);
        db.getString(repRec).delete();
        db.free(valueRec);
    }
}

