/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeByImageLocation
extends CPPASTVisitor
implements ICASTVisitor {
    private final int fOffset;
    private final int fLength;
    private final ASTNodeSpecification<?> fNodeSpec;

    public FindNodeByImageLocation(int offset, int length, ASTNodeSpecification<?> nodeSpec) {
        this.fNodeSpec = nodeSpec;
        this.fOffset = offset;
        this.fLength = length;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = !nodeSpec.requiresClass(IASTName.class);
        this.shouldVisitTemplateParameters = this.shouldVisitTranslationUnit;
        this.shouldVisitNamespaces = this.shouldVisitTranslationUnit;
        this.shouldVisitBaseSpecifiers = this.shouldVisitTranslationUnit;
        this.shouldVisitEnumerators = this.shouldVisitTranslationUnit;
        this.shouldVisitTypeIds = this.shouldVisitTranslationUnit;
        this.shouldVisitStatements = this.shouldVisitTranslationUnit;
        this.shouldVisitExpressions = this.shouldVisitTranslationUnit;
        this.shouldVisitEnumerators = this.shouldVisitTranslationUnit;
        this.shouldVisitDesignators = this.shouldVisitTranslationUnit;
        this.shouldVisitDeclSpecifiers = this.shouldVisitTranslationUnit;
        this.shouldVisitDeclarators = this.shouldVisitTranslationUnit;
        this.shouldVisitParameterDeclarations = this.shouldVisitTranslationUnit;
        this.shouldVisitInitializers = this.shouldVisitTranslationUnit;
    }

    public int processNode(IASTNode node) {
        if (node instanceof ASTNode) {
            IASTImageLocation imageLocation;
            ASTNode astNode = (ASTNode)node;
            if (astNode.getOffset() > this.fOffset + this.fLength || astNode.getOffset() + astNode.getLength() < this.fOffset) {
                return 1;
            }
            if (this.fNodeSpec.isAcceptableNode(astNode) && (imageLocation = astNode.getImageLocation()) != null && imageLocation.getLocationKind() == 3) {
                this.fNodeSpec.visit(astNode, imageLocation);
            }
        }
        return 3;
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        if (declaration instanceof ASTNode && ((ASTNode)((Object)declaration)).getOffset() > this.fOffset + this.fLength) {
            return 2;
        }
        return this.processNode(declaration);
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        return this.processNode(declarator);
    }

    @Override
    public int visit(IASTDeclSpecifier declSpec) {
        return this.processNode(declSpec);
    }

    @Override
    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        return this.processNode(enumerator);
    }

    @Override
    public int visit(IASTExpression expression) {
        return this.processNode(expression);
    }

    @Override
    public int visit(IASTInitializer initializer) {
        return this.processNode(initializer);
    }

    @Override
    public int visit(IASTName name) {
        if (name.toString() != null) {
            return this.processNode(name);
        }
        return 3;
    }

    @Override
    public int visit(IASTParameterDeclaration parameterDeclaration) {
        return this.processNode(parameterDeclaration);
    }

    @Override
    public int visit(IASTStatement statement) {
        return this.processNode(statement);
    }

    @Override
    public int visit(IASTTypeId typeId) {
        return this.processNode(typeId);
    }

    @Override
    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
        return this.processNode(baseSpecifier);
    }

    @Override
    public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
        return this.processNode(namespaceDefinition);
    }

    @Override
    public int visit(ICPPASTTemplateParameter templateParameter) {
        return this.processNode(templateParameter);
    }

    @Override
    public int visit(IASTProblem problem) {
        return this.processNode(problem);
    }

    @Override
    public int visit(ICASTDesignator designator) {
        return this.processNode(designator);
    }

    @Override
    public int leave(ICASTDesignator designator) {
        return 3;
    }

    @Override
    public int visit(IASTTranslationUnit tu) {
        return this.processNode(tu);
    }
}

