/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.ptp.internal.rdt.core.model.FunctionInfo;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.SourceManipulation;

public class FunctionDeclaration
extends SourceManipulation
implements IFunctionDeclaration {
    private static final long serialVersionUID = 1L;
    protected String[] fParameterTypes;
    protected String fReturnType;
    protected boolean fIsConst;
    protected boolean fIsStatic;
    protected boolean fIsVolatile;

    public FunctionDeclaration(Parent parent, String functionName) {
        super((ICElement)parent, 73, functionName);
    }

    protected FunctionDeclaration(Parent parent, int kind, String name) {
        super((ICElement)parent, kind, name);
    }

    protected FunctionDeclaration(Parent parent, IFunctionDeclaration element) throws CModelException {
        super((ICElement)parent, (ICElement)element, (ISourceReference)element);
        this.fParameterTypes = element.getParameterTypes();
        this.fReturnType = element.getReturnType();
        this.fIsConst = element.isConst();
        this.fIsStatic = element.isStatic();
        this.fIsVolatile = element.isVolatile();
    }

    public FunctionDeclaration(Parent parent, int type, IFunction function) throws DOMException {
        super((ICElement)parent, type, function.getName());
        this.fParameterTypes = this.extractParameterTypes(function);
        this.fReturnType = function.getType().getReturnType().toString();
        this.fIsStatic = function.isStatic();
    }

    public FunctionDeclaration(Parent parent, IFunction binding) throws DOMException {
        this(parent, 73, binding);
    }

    public String[] getExceptions() {
        return null;
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes.length;
    }

    public String getParameterInitializer(int pos) {
        return null;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getReturnType() {
        return this.fReturnType;
    }

    public String getSignature() throws CModelException {
        return null;
    }

    public boolean isConst() throws CModelException {
        return this.fIsConst;
    }

    public boolean isStatic() throws CModelException {
        return this.fIsStatic;
    }

    public boolean isVolatile() throws CModelException {
        return this.fIsVolatile;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.fParameterTypes = parameterTypes;
    }

    public void setReturnType(String returnType) {
        this.fReturnType = returnType;
    }

    public FunctionInfo getFunctionInfo() {
        if (this.fInfo == null) {
            this.fInfo = new FunctionInfo(this);
        }
        return (FunctionInfo)this.fInfo;
    }

    public FunctionInfo getElementInfo() {
        return this.getFunctionInfo();
    }

    public void setConst(boolean isConst) {
        this.fIsConst = isConst;
    }

    public void setStatic(boolean isStatic) {
        this.fIsStatic = isStatic;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof IFunctionDeclaration)) {
            return false;
        }
        IFunctionDeclaration other = (IFunctionDeclaration)o;
        if (!Arrays.equals(this.fParameterTypes, other.getParameterTypes())) {
            return false;
        }
        String returnType = other.getReturnType();
        return this.fReturnType == null || this.fReturnType.equals(returnType);
    }
}

