/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPQualifierType
implements IQualifierType,
ITypeContainer,
ISerializableType {
    private final boolean isConst;
    private final boolean isVolatile;
    private IType type;

    public CPPQualifierType(IType type, boolean isConst, boolean isVolatile) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
    }

    public boolean isSameType(IType o) {
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (!(o instanceof IQualifierType)) {
            return false;
        }
        IQualifierType pt = (IQualifierType)o;
        if (this.isConst() == pt.isConst() && this.isVolatile() == pt.isVolatile() && this.type != null) {
            return this.type.isSameType(pt.getType());
        }
        return false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 4;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPQualifierType(nested, (firstByte & 0x10) != 0, (firstByte & 0x20) != 0);
    }
}

