/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.core.runtime.IStatus;

public class QualifiedTypeName
implements IQualifiedTypeName {
    private static final String[] NO_SEGMENTS = new String[0];
    private static final String EMPTY_STRING = "";
    private static final int INITIAL_SEGMENT_LENGTH = 12;
    private static final int HASH_INIT = 17;
    private static final int HASH_MULTIPLIER = 37;
    private String[] fSegments = NO_SEGMENTS;
    private int fHashCode = 0;
    public static final QualifiedTypeName EMPTY = new QualifiedTypeName();

    public QualifiedTypeName(IQualifiedTypeName typeName) {
        this.fSegments = typeName.segments();
    }

    public QualifiedTypeName(String qualifiedName) {
        this.fSegments = this.createSegments(qualifiedName);
    }

    public QualifiedTypeName(String[] names) {
        this.fSegments = this.createSegments(names);
    }

    public QualifiedTypeName(String name, String[] enclosingNames) {
        this.fSegments = enclosingNames == null ? this.createSegments(name) : this.createSegments(name, enclosingNames);
    }

    private QualifiedTypeName() {
    }

    private String[] createSegments(String qualifiedName) {
        String[] segments;
        int qualifierIndex = qualifiedName.indexOf("::", 0);
        if (qualifierIndex == -1) {
            segments = new String[]{qualifiedName};
        } else {
            int maxSegments = 1;
            int lastIndex = 0;
            while (qualifierIndex >= 0) {
                lastIndex = qualifierIndex + "::".length();
                ++maxSegments;
                qualifierIndex = qualifiedName.indexOf("::", lastIndex);
            }
            segments = new String[maxSegments];
            int segmentCount = 0;
            lastIndex = 0;
            qualifierIndex = qualifiedName.indexOf("::", 0);
            while (qualifierIndex >= 0) {
                segments[segmentCount] = new String(qualifiedName.substring(lastIndex, qualifierIndex));
                ++segmentCount;
                lastIndex = qualifierIndex + "::".length();
                qualifierIndex = qualifiedName.indexOf("::", lastIndex);
            }
            segments[segmentCount] = new String(qualifiedName.substring(lastIndex));
        }
        return segments;
    }

    private String[] createSegments(String[] names) {
        String[] segments = new String[names.length];
        System.arraycopy(names, 0, segments, 0, names.length);
        return segments;
    }

    private String[] createSegments(String name, String[] enclosingNames) {
        String[] segments = new String[enclosingNames.length + 1];
        System.arraycopy(enclosingNames, 0, segments, 0, enclosingNames.length);
        segments[segments.length - 1] = name;
        return segments;
    }

    public String getName() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return EMPTY_STRING;
    }

    public String[] getEnclosingNames() {
        if (this.fSegments.length > 1) {
            String[] enclosingNames = new String[this.fSegments.length - 1];
            System.arraycopy(this.fSegments, 0, enclosingNames, 0, this.fSegments.length - 1);
            return enclosingNames;
        }
        return NO_SEGMENTS;
    }

    public String getFullyQualifiedName() {
        if (this.fSegments.length > 0) {
            StringBuffer buf = new StringBuffer(this.fSegments.length * 12);
            int i = 0;
            while (i < this.fSegments.length) {
                if (i > 0) {
                    buf.append("::");
                }
                buf.append(this.fSegments[i]);
                ++i;
            }
            return buf.toString();
        }
        return EMPTY_STRING;
    }

    public IQualifiedTypeName getEnclosingTypeName() {
        String[] enclosingNames = this.getEnclosingNames();
        if (enclosingNames.length > 0) {
            QualifiedTypeName enclosingTypeName = new QualifiedTypeName();
            enclosingTypeName.fSegments = enclosingNames;
            return enclosingTypeName;
        }
        return null;
    }

    public boolean isQualified() {
        return this.fSegments.length > 1;
    }

    public boolean isEmpty() {
        return this.fSegments.length == 0;
    }

    public boolean isGlobal() {
        return this.fSegments.length <= 1 || this.fSegments[0].length() == 0;
    }

    public int segmentCount() {
        return this.fSegments.length;
    }

    public String[] segments() {
        String[] segmentCopy = new String[this.fSegments.length];
        System.arraycopy(this.fSegments, 0, segmentCopy, 0, this.fSegments.length);
        return segmentCopy;
    }

    public String segment(int index) {
        if (index >= this.fSegments.length) {
            return null;
        }
        return this.fSegments[index];
    }

    public String lastSegment() {
        if (this.fSegments.length > 0) {
            return this.fSegments[this.fSegments.length - 1];
        }
        return null;
    }

    public int matchingFirstSegments(IQualifiedTypeName typeName) {
        int max = Math.min(this.fSegments.length, typeName.segmentCount());
        int count = 0;
        int i = 0;
        while (i < max) {
            if (!this.fSegments[i].equals(typeName.segment(i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public boolean isPrefixOf(IQualifiedTypeName typeName) {
        if (this.fSegments.length == 0) {
            return true;
        }
        if (this.fSegments.length > typeName.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < this.fSegments.length) {
            if (!this.fSegments[i].equals(typeName.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IQualifiedTypeName append(String[] names) {
        int length = this.fSegments.length;
        int typeNameLength = names.length;
        String[] newSegments = new String[length + typeNameLength];
        System.arraycopy(this.fSegments, 0, newSegments, 0, length);
        System.arraycopy(names, 0, newSegments, length, typeNameLength);
        QualifiedTypeName newTypeName = new QualifiedTypeName();
        newTypeName.fSegments = newSegments;
        return newTypeName;
    }

    public IQualifiedTypeName append(IQualifiedTypeName typeName) {
        int length = this.fSegments.length;
        int typeNameLength = typeName.segmentCount();
        String[] newSegments = new String[length + typeNameLength];
        System.arraycopy(this.fSegments, 0, newSegments, 0, length);
        int i = 0;
        while (i < typeNameLength) {
            newSegments[i + length] = typeName.segment(i);
            ++i;
        }
        QualifiedTypeName newTypeName = new QualifiedTypeName();
        newTypeName.fSegments = newSegments;
        return newTypeName;
    }

    public IQualifiedTypeName append(String qualifiedName) {
        return this.append(this.createSegments(qualifiedName));
    }

    public IQualifiedTypeName removeFirstSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.fSegments.length || count < 0) {
            return EMPTY;
        }
        int newSize = this.fSegments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.fSegments, count, newSegments, 0, newSize);
        QualifiedTypeName newTypeName = new QualifiedTypeName();
        newTypeName.fSegments = newSegments;
        return newTypeName;
    }

    public IQualifiedTypeName removeLastSegments(int count) {
        if (count == 0) {
            return this;
        }
        if (count >= this.fSegments.length || count < 0) {
            return EMPTY;
        }
        int newSize = this.fSegments.length - count;
        String[] newSegments = new String[newSize];
        System.arraycopy(this.fSegments, 0, newSegments, 0, newSize);
        QualifiedTypeName newTypeName = new QualifiedTypeName();
        newTypeName.fSegments = newSegments;
        return newTypeName;
    }

    public boolean isLowLevel() {
        int i = 0;
        while (i < this.fSegments.length) {
            if (this.fSegments[i].startsWith("_")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isValid() {
        int i = 0;
        while (i < this.fSegments.length) {
            String segment = this.fSegments[i];
            IStatus val = CConventions.validateIdentifier((String)segment);
            if (val.getSeverity() == 4) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isValidSegment(String segment) {
        if (segment.indexOf("::") != -1) {
            return false;
        }
        IStatus val = CConventions.validateIdentifier((String)segment);
        return val.getSeverity() != 4;
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = 17;
            int i = 0;
            while (i < this.fSegments.length) {
                this.fHashCode = this.fHashCode * 37 + this.fSegments[i].hashCode();
                ++i;
            }
        }
        return this.fHashCode;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    public int compareTo(IQualifiedTypeName typeName) {
        if (typeName == this) {
            return 0;
        }
        if (typeName == null) {
            return 1;
        }
        int length = this.fSegments.length;
        int typeNameLength = typeName.segmentCount();
        int len = Math.min(length, typeNameLength);
        int result = 0;
        int i = 0;
        while (result == 0 && i < len) {
            result = this.fSegments[i].compareTo(typeName.segment(i));
            ++i;
        }
        if (result == 0 && length != typeNameLength) {
            result = length < typeNameLength ? -1 : 1;
        }
        return result;
    }

    public int compareToIgnoreCase(IQualifiedTypeName typeName) {
        if (typeName == this) {
            return 0;
        }
        if (typeName == null) {
            return 1;
        }
        int length = this.fSegments.length;
        int typeNameLength = typeName.segmentCount();
        int len = Math.min(length, typeNameLength);
        int result = 0;
        int i = 0;
        while (result == 0 && i < len) {
            result = this.fSegments[i].compareToIgnoreCase(typeName.segment(i));
            ++i;
        }
        if (result == 0 && length != typeNameLength) {
            result = length < typeNameLength ? -1 : 1;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IQualifiedTypeName)) {
            return false;
        }
        return this.equals((IQualifiedTypeName)obj);
    }

    public boolean equals(IQualifiedTypeName typeName) {
        if (typeName == this) {
            return true;
        }
        if (typeName == null) {
            return false;
        }
        int length = this.fSegments.length;
        int typeNameLength = typeName.segmentCount();
        if (length != typeNameLength) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.fSegments[i].equals(typeName.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(IQualifiedTypeName typeName) {
        if (typeName == this) {
            return true;
        }
        if (typeName == null) {
            return false;
        }
        int length = this.fSegments.length;
        int typeNameLength = typeName.segmentCount();
        if (length != typeNameLength) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.fSegments[i].equalsIgnoreCase(typeName.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

