/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import java.net.URI;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.core.activator.Activator;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.services.core.ServiceProvider;

public class RemoteBuildServiceProvider
extends ServiceProvider
implements IRemoteExecutionServiceProvider {
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID = "RemoteBuildServiceProvider.remoteToolsProviderID";
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME = "RemoteBuildServiceProvider.remoteToolsConnectionName";
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_CONFIG_LOCATION = "RemoteBuildServiceProvider.configLocation";
    public static final String ID = "org.eclipse.ptp.rdt.ui.RemoteBuildServiceProvider";
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.BuildService";
    public static final String NAME = Messages.getString("RemoteBuildServiceProvider.0");
    private IRemoteConnection fRemoteConnection = null;

    private static String getDefaultPath(IRemoteServices remoteServices, IRemoteConnection connection) {
        if (!remoteServices.isInitialized()) {
            remoteServices.initialize();
        }
        if (remoteServices == null || connection == null) {
            return null;
        }
        String homeDir = connection.getProperty("user.home");
        if (homeDir != null) {
            IFileStore homeStore = remoteServices.getFileManager(connection).getResource(homeDir);
            URI uri = homeStore.toURI();
            String pathString = EFSExtensionManager.getDefault().getPathFromURI(uri);
            Path path = new Path(pathString);
            path = path.append(RSEUtils.DEFAULT_CONFIG_DIR_NAME);
            return path.toString();
        }
        return null;
    }

    public String getConfigLocation() {
        return this.getString(REMOTE_BUILD_SERVICE_PROVIDER_CONFIG_LOCATION, RemoteBuildServiceProvider.getDefaultPath(this.getRemoteServices(), this.getConnection()));
    }

    public void setConfigLocation(String configLocation) {
        this.putString(REMOTE_BUILD_SERVICE_PROVIDER_CONFIG_LOCATION, configLocation);
    }

    public String getConfigurationString() {
        if (this.isConfigured()) {
            return String.valueOf(this.getRemoteServices().getName()) + ": " + this.getRemoteConnectionName();
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        IRemoteServices services;
        if (this.fRemoteConnection == null && this.getRemoteConnectionName() != null && (services = this.getRemoteServices()) != null) {
            IRemoteConnectionManager manager;
            if (!services.isInitialized()) {
                services.initialize();
            }
            if ((manager = services.getConnectionManager()) != null) {
                this.fRemoteConnection = manager.getConnection(this.getRemoteConnectionName());
                if (this.fRemoteConnection != null && !this.fRemoteConnection.isOpen()) {
                    try {
                        this.fRemoteConnection.open((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (RemoteConnectionException e) {
                        Activator.log((Throwable)e);
                        return null;
                    }
                }
            }
        }
        return this.fRemoteConnection;
    }

    public String getRemoteConnectionName() {
        return this.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME, null);
    }

    public IRemoteServices getRemoteServices() {
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getRemoteToolsProviderID());
        if (!remoteServices.isInitialized()) {
            remoteServices.initialize();
        }
        return remoteServices;
    }

    public String getRemoteToolsProviderID() {
        return this.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID, null);
    }

    public boolean isConfigured() {
        return this.getRemoteToolsProviderID() != null && this.getRemoteConnectionName() != null;
    }

    public void setRemoteToolsConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
        String name = "";
        if (connection != null) {
            name = connection.getName();
        }
        this.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME, name);
    }

    public void setRemoteToolsProviderID(String id) {
        this.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID, id);
    }

    public String toString() {
        return "RemoteBuildServiceProvider(" + this.getRemoteConnectionName() + ")";
    }
}

