/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.CallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.ResourceCollector;

public class GraphCreator {
    public ICallGraph createCallGraph(IResource resource) {
        ICallGraph cg = this.initCallGraph(resource);
        this.computeCallGraph(cg);
        return cg;
    }

    public ICallGraph initCallGraph(IResource resource) {
        ICallGraph callGraph = new CallGraph();
        callGraph = this.initCallGraph(resource, callGraph);
        return callGraph;
    }

    public ICallGraph initCallGraph(IResource resource, ICallGraph callGraph) {
        boolean foundError = this.resourceCollector(resource, callGraph);
        if (foundError) {
            System.out.println("Error occurred during call graph creation.");
        }
        return callGraph;
    }

    public ICallGraph initCallGraph() {
        return new CallGraph();
    }

    public ICallGraph computeCallGraph(ICallGraph callGraph) {
        callGraph.buildCG();
        return callGraph;
    }

    public boolean resourceCollector(IResource resource, ICallGraph callGraph) {
        boolean foundError = false;
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String filename = file.getName();
            if (filename.endsWith(".c")) {
                ResourceCollector rc = new ResourceCollector(callGraph, file);
                rc.run();
            }
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            try {
                IResource[] mems = container.members();
                int i = 0;
                while (i < mems.length) {
                    boolean err = this.resourceCollector(mems[i], callGraph);
                    foundError = foundError || err;
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                foundError = true;
            }
        } else {
            String name = "";
            if (resource instanceof IResource) {
                IResource res = resource;
                IPath path = res.getProjectRelativePath();
                name = path.toString();
            }
            System.out.println("Cancelled by User, aborting analysis on subsequent files... " + name);
        }
        return foundError;
    }

    public void showCallGraph(ICallGraph cg) {
        System.out.println("Show call graph");
        List<ICallGraphNode> nodes = cg.getAllNodes();
        for (ICallGraphNode cgNode : nodes) {
            this.printCGNode(cgNode, "");
            for (ICallGraphNode caller : cgNode.getCallers()) {
                this.printCGNode(caller, "    caller: ");
            }
            for (ICallGraphNode callee : cgNode.getCallees()) {
                this.printCGNode(callee, "    callee: ");
            }
            System.out.println(" ");
        }
        List<List<ICallGraphNode>> cycles = cg.getCycles();
        System.out.println("Recursive cycles:");
        for (List<ICallGraphNode> cycle : cycles) {
            System.out.println("Cycle: ");
            for (ICallGraphNode fn : cycle) {
                System.out.print(" " + fn.getFuncName());
            }
            System.out.println(" \n");
        }
        List<String> vars = cg.getEnv();
        System.out.println("Global variables:");
        for (String var : vars) {
            System.out.println("Global var: " + var);
        }
    }

    public void printCGNode(ICallGraphNode cgNode, String prefix) {
        System.out.println(String.valueOf(prefix) + " " + cgNode.getFuncName() + " in " + cgNode.getFileName());
        cgNode.getCFG();
    }
}

