/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPackExpansionExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameterPackType;

public class CPPASTPackExpansionExpression
extends ASTNode
implements ICPPASTPackExpansionExpression,
IASTAmbiguityParent {
    private IASTExpression fPattern;

    public CPPASTPackExpansionExpression(IASTExpression pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(IASTExpression pattern) {
        this.assertNotFrozen();
        this.fPattern = pattern;
        if (pattern != null) {
            pattern.setParent(this);
            pattern.setPropertyInParent(ICPPASTPackExpansionExpression.PATTERN);
        }
    }

    public IASTExpression getPattern() {
        return this.fPattern;
    }

    public IASTExpression copy() {
        CPPASTPackExpansionExpression copy = new CPPASTPackExpansionExpression(this.fPattern.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IType getExpressionType() {
        IType type = this.fPattern.getExpressionType();
        if (type == null) {
            return new ProblemBinding(this, 5, this.getRawSignatureChars());
        }
        return new CPPParameterPackType(type);
    }

    public boolean isLValue() {
        return this.fPattern.isLValue();
    }

    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitExpressions) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.fPattern.accept(visitor)) {
            return false;
        }
        return !visitor.shouldVisitExpressions || visitor.leave(this) != 2;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fPattern) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fPattern = (IASTExpression)other;
        }
    }
}

