/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core.miners;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.ptp.internal.remote.rse.core.miners.CommandMinerThread;

public class OutputHandler
extends Handler {
    private DataInputStream _reader;
    private boolean _isStdError;
    private boolean _isTerminal;
    private CommandMinerThread fCommandThread;
    private boolean _isShell;
    private boolean _endOfStream = false;
    private List<String> _encodings;
    private String fCwd;
    private BufferedReader fBufferedReader;
    private boolean fIsFinished;

    public OutputHandler(DataInputStream reader, String qualifier, boolean isTerminal, boolean isStdError, boolean isShell, CommandMinerThread commandThread, String cwd) {
        this._reader = reader;
        this._isStdError = isStdError;
        this._isTerminal = isTerminal;
        this.fCommandThread = commandThread;
        this._isShell = isShell;
        this.fCwd = cwd;
        this._encodings = new ArrayList<String>();
        String system = System.getProperty("os.name").toLowerCase();
        if (system.startsWith("z")) {
            this._encodings.add("IBM-1047");
        } else {
            String specialEncoding = System.getProperty("dstore.stdin.encoding");
            if (specialEncoding != null) {
                this._encodings.add(specialEncoding);
            }
            this._encodings.add(System.getProperty("file.encoding"));
        }
        for (String encoding : this._encodings) {
            try {
                this.fBufferedReader = new BufferedReader(new InputStreamReader((InputStream)this._reader, encoding));
                break;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void handle() {
        String[] lines = this.readLines();
        if (lines != null) {
            int i = 0;
            while (i < lines.length) {
                String ln = lines[i];
                if (ln.indexOf(10) > 0) {
                    String[] lns = ln.split("\n");
                    int j = 0;
                    while (j < lns.length) {
                        String line = this.convertSpecialCharacters(lns[j]);
                        this.fCommandThread.interpretLine(line, this._isStdError);
                        ++j;
                    }
                } else {
                    String line = this.convertSpecialCharacters(ln);
                    this.fCommandThread.interpretLine(line, this._isStdError);
                }
                ++i;
            }
            if (!this._isTerminal) {
                this.doPrompt();
            }
            this.fCommandThread.refreshStatus();
        } else {
            this.finish();
        }
    }

    public synchronized void finish() {
        if (!this.fIsFinished) {
            this.fIsFinished = true;
            super.finish();
            try {
                this.fBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String convertSpecialCharacters(String input) {
        if (this.fCommandThread._supportsCharConversion) {
            StringBuffer output = new StringBuffer();
            int idx = 0;
            while (idx < input.length()) {
                char currChar = input.charAt(idx);
                switch (currChar) {
                    case '&': {
                        output.append("&#38;");
                        break;
                    }
                    case ';': {
                        output.append("&#59;");
                        break;
                    }
                    default: {
                        output.append(currChar);
                    }
                }
                ++idx;
            }
            return output.toString();
        }
        return input;
    }

    private void doPrompt() {
        block5: {
            try {
                if (this._isStdError || !this._isShell || this._reader.available() != 0 || this._isTerminal) break block5;
                try {
                    Thread.sleep(200L);
                    if (this._reader.available() == 0) {
                        this.fCommandThread.createPrompt(String.valueOf(this.fCwd) + '>', this.fCwd);
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                this.fCommandThread._dataStore.trace((Throwable)e);
            }
        }
    }

    private String[] readLines() {
        ArrayList<String> outputLines;
        String[] output;
        block5: {
            if (this._endOfStream || this.fBufferedReader == null) {
                return null;
            }
            output = new String[]{};
            outputLines = new ArrayList<String>();
            try {
                String line = this.fBufferedReader.readLine();
                if (line != null) {
                    outputLines.add(line);
                    break block5;
                }
                this._endOfStream = true;
                return null;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                this._endOfStream = true;
                e.printStackTrace();
            }
        }
        return outputLines.toArray(output);
    }

    public synchronized void waitForInput() {
    }
}

