/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.core.runtime.Assert;

public class CPPTypedefSpecialization
extends CPPSpecialization
implements ITypedef,
ITypeContainer {
    public static final int MAX_RESOLUTION_DEPTH = 5;
    public static final int MAX_TYPE_NESTING = 100;
    private IType type;
    private int fResolutionDepth;

    public CPPTypedefSpecialization(IBinding specialized, ICPPClassType owner, ICPPTemplateParameterMap tpmap) {
        super(specialized, owner, tpmap);
    }

    private ITypedef getTypedef() {
        return (ITypedef)this.getSpecializedBinding();
    }

    public IType getType() {
        block7: {
            if (this.type == null) {
                try {
                    if (++this.fResolutionDepth > 5) {
                        this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                        break block7;
                    }
                    IType checkType = this.type = this.specializeType(this.getTypedef().getType());
                    int i = 0;
                    while (checkType instanceof ITypeContainer) {
                        if (this.equals(checkType) || i == 100) {
                            this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                            break;
                        }
                        checkType = ((ITypeContainer)checkType).getType();
                        ++i;
                    }
                }
                finally {
                    --this.fResolutionDepth;
                }
            }
        }
        return this.type;
    }

    public int incResolutionDepth(int increment) {
        this.fResolutionDepth += increment;
        return this.fResolutionDepth;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(((ITypedef)o).getType());
            }
            return false;
        }
        IType t = this.getType();
        if (t != null) {
            return t.isSameType(o);
        }
        return false;
    }

    public void setType(IType type) {
        this.type = type;
    }

    static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding(IASTNode node, char[] arg) {
            super(node, 14, arg);
            Assert.isTrue((boolean)CPPASTNameBase.sAllowRecursionBindings, (String)this.getMessage());
        }
    }
}

