/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rm.core.rmsystem.AbstractRemoteResourceManagerServiceProvider;
import org.eclipse.ptp.rm.ibm.pe.core.PEPreferenceManager;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.IPEResourceManagerConfiguration;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.PEResourceManager;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderWorkingCopy;

public class PEServiceProvider
extends AbstractRemoteResourceManagerServiceProvider
implements IPEResourceManagerConfiguration {
    private static final String TAG_USE_LOADLEVELER = "PE_UseLoadLeveler";
    private static final String TAG_DEBUG_LEVEL = "PE_DebugLevel";
    private static final String TAG_RUN_MINIPROXY = "PE_RunMiniproxy";
    private static final String TAG_SUSPEND_PROXY = "PE_SuspendProxy";
    private static final String TAG_LOADLEVELER_MODE = "PE_LoadLevelerMode";
    private static final String TAG_MIN_NODE_POLL_INTERVAL = "PE_NodeMinPollInterval";
    private static final String TAG_MAX_NODE_POLL_INTERVAL = "PE_NodeMaxPollInterval";
    private static final String TAG_JOB_POLL_INTERVAL = "PE_JobPollInterval";
    private static final String TAG_LIBRARY_OVERRIDE = "PE_LibraryOverride";
    private Preferences preferences = PEPreferenceManager.getPreferences();

    public PEServiceProvider() {
        this.setDescription("IBM PE Resource Manager");
    }

    public PEServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    public IServiceProviderWorkingCopy copy() {
        return new PEServiceProvider((IServiceProvider)this);
    }

    public IResourceManagerControl createResourceManager() {
        IPUniverseControl universe = (IPUniverseControl)PTPCorePlugin.getDefault().getUniverse();
        return new PEResourceManager(Integer.valueOf(universe.getNextResourceManagerId()), universe, (IResourceManagerConfiguration)this);
    }

    public String getDebugLevel() {
        return this.getString(TAG_DEBUG_LEVEL, this.preferences.getString("PE_traceLevel"));
    }

    public String getJobPollInterval() {
        return this.getString(TAG_JOB_POLL_INTERVAL, this.preferences.getString(TAG_JOB_POLL_INTERVAL));
    }

    public String getLibraryOverride() {
        return this.getString(TAG_LIBRARY_OVERRIDE, this.preferences.getString("PE_libraryOverride"));
    }

    public String getLoadLevelerMode() {
        return this.getString(TAG_LOADLEVELER_MODE, this.preferences.getString(TAG_LOADLEVELER_MODE));
    }

    public String getNodeMaxPollInterval() {
        return this.getString(TAG_MAX_NODE_POLL_INTERVAL, this.preferences.getString(TAG_MAX_NODE_POLL_INTERVAL));
    }

    public String getNodeMinPollInterval() {
        return this.getString(TAG_MIN_NODE_POLL_INTERVAL, this.preferences.getString(TAG_MIN_NODE_POLL_INTERVAL));
    }

    public String getResourceManagerId() {
        return this.getId();
    }

    public String getRunMiniproxy() {
        return this.getString(TAG_RUN_MINIPROXY, this.preferences.getString("PE_runMiniproxy"));
    }

    public String getSuspendProxy() {
        return this.getString(TAG_SUSPEND_PROXY, "n");
    }

    public String getUseLoadLeveler() {
        return this.getString(TAG_USE_LOADLEVELER, this.preferences.getString("PE_useLoadLeveler"));
    }

    public boolean isConfigured() {
        return true;
    }

    public void setDebugLevel(String debugLevel) {
        this.putString(TAG_DEBUG_LEVEL, debugLevel);
    }

    public void setDefaultNameAndDesc() {
        String name = "IBM PE";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals("")) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("IBM PE Resource Manager");
    }

    public void setJobPollInterval(String interval) {
        this.putString(TAG_JOB_POLL_INTERVAL, interval);
    }

    public void setLibraryOverride(String override) {
        this.putString(TAG_LIBRARY_OVERRIDE, override);
    }

    public void setLoadLevelerMode(String mode) {
        this.putString(TAG_LOADLEVELER_MODE, mode);
    }

    public void setNodeMaxPollInterval(String interval) {
        this.putString(TAG_MAX_NODE_POLL_INTERVAL, interval);
    }

    public void setNodeMinPollInterval(String interval) {
        this.putString(TAG_MIN_NODE_POLL_INTERVAL, interval);
    }

    public void setRunMiniproxy(String flag) {
        this.putString(TAG_RUN_MINIPROXY, flag);
    }

    public void setSuspendProxy(String flag) {
        this.putString(TAG_SUSPEND_PROXY, flag);
    }

    public void setUseLoadLeveler(String flag) {
        this.putString(TAG_USE_LOADLEVELER, flag);
    }
}

