/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.messages.Messages;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.debug.core.sourcelookup.IProjectSourceLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PProjectSourceLocation
implements IProjectSourceLocation {
    private static final String ELEMENT_NAME = "cProjectSourceLocation";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_GENERIC = "generic";
    private IProject fProject;
    private IResource[] fFolders;
    private HashMap<String, Object> fCache = new HashMap(20);
    private HashSet<String> fNotFoundCache = new HashSet(20);
    private boolean fGenerated = true;
    private boolean fSearchForDuplicateFiles = false;

    public PProjectSourceLocation() {
    }

    public PProjectSourceLocation(IProject project) {
        this.setProject(project);
        this.fGenerated = true;
    }

    public PProjectSourceLocation(IProject project, boolean generated) {
        this.setProject(project);
        this.fGenerated = generated;
    }

    public void dispose() {
        this.fCache.clear();
        this.fNotFoundCache.clear();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProjectSourceLocation && this.getProject() != null) {
            return this.getProject().equals((Object)((IProjectSourceLocation)obj).getProject());
        }
        return false;
    }

    public Object findSourceElement(String name) throws CoreException {
        Object result = null;
        if (!this.isEmpty(name) && this.getProject() != null && !this.notFoundCacheLookup(name)) {
            result = this.cacheLookup(name);
            if (result == null && (result = this.doFindSourceElement(name)) != null) {
                this.cacheSourceElement(name, result);
            }
            if (result == null) {
                this.cacheNotFound(name);
            }
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPSourceLocation.class)) {
            return this;
        }
        if (adapter.equals(PProjectSourceLocation.class)) {
            return this;
        }
        if (adapter.equals(IProject.class)) {
            return this.getProject();
        }
        return null;
    }

    public String getMemento() throws CoreException {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(ELEMENT_NAME);
            document.appendChild(node);
            node.setAttribute(ATTR_PROJECT, this.getProject().getName());
            node.setAttribute(ATTR_GENERIC, new Boolean(this.isGeneric()).toString());
            return PDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        this.abort(NLS.bind((String)Messages.PProjectSourceLocation_0, (Object[])new Object[]{this.getProject().getName()}), ex);
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String name = root.getAttribute(ATTR_PROJECT);
            if (this.isEmpty(name)) {
                this.abort(Messages.PProjectSourceLocation_1, null);
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                this.setProject(project);
            }
            String isGeneric = root.getAttribute(ATTR_GENERIC);
            if (isGeneric == null || isGeneric.trim().length() == 0) {
                isGeneric = Boolean.FALSE.toString();
            }
            this.setGenerated(isGeneric.equals(Boolean.TRUE.toString()));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(Messages.PProjectSourceLocation_2, ex);
    }

    public boolean isGeneric() {
        return this.fGenerated;
    }

    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles;
    }

    public void setGenerated(boolean b) {
        this.fGenerated = b;
    }

    public void setSearchForDuplicateFiles(boolean search) {
        this.fCache.clear();
        this.fNotFoundCache.clear();
        this.fSearchForDuplicateFiles = search;
    }

    public String toString() {
        return this.getProject() != null ? this.fProject.toString() : "";
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private Object cacheLookup(String name) {
        return this.fCache.get(name);
    }

    private void cacheNotFound(String name) {
        this.fNotFoundCache.add(name);
    }

    private void cacheSourceElement(String name, Object element) {
        this.fCache.put(name, element);
    }

    private Object doFindSourceElement(String name) {
        File file = new File(name);
        return file.isAbsolute() ? this.findFileByAbsolutePath(file) : this.findFileByRelativePath(name);
    }

    private Object findFileByAbsolutePath(File file) {
        LinkedList<IFile> list = new LinkedList<IFile>();
        if (file.exists()) {
            Path path = new Path(file.getAbsolutePath());
            IFile[] wsFiles = PTPDebugCorePlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            int i = 0;
            while (i < wsFiles.length) {
                if (wsFiles[i].getProject().equals((Object)this.getProject()) && wsFiles[i].exists()) {
                    if (!this.searchForDuplicateFiles()) {
                        return wsFiles[i];
                    }
                    list.add(wsFiles[i]);
                }
                ++i;
            }
        }
        return list.size() > 0 ? (list.size() == 1 ? list.getFirst() : list) : null;
    }

    private Object findFileByRelativePath(String fileName) {
        IResource[] folders = this.getFolders();
        LinkedList<IFile> list = new LinkedList<IFile>();
        int i = 0;
        while (i < folders.length) {
            File file;
            if (list.size() > 0 && !this.searchForDuplicateFiles()) break;
            IPath path = folders[i].getLocation();
            if (path != null && (file = new File((path = path.append(fileName)).toOSString())).exists()) {
                IFile[] wsFiles = PTPDebugCorePlugin.getWorkspace().getRoot().findFilesForLocation(path);
                int j = 0;
                while (j < wsFiles.length) {
                    if (wsFiles[j].exists()) {
                        if (!this.searchForDuplicateFiles()) {
                            return wsFiles[j];
                        }
                        list.add(wsFiles[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.size() > 0 ? (list.size() == 1 ? list.getFirst() : list) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFolders() {
        final LinkedList<IProject> list = new LinkedList<IProject>();
        if (this.getProject() != null && this.getProject().exists()) {
            list.add(this.getProject());
            try {
                this.getProject().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                return false;
                            }
                            case 2: {
                                list.addLast(proxy.requestResource());
                                return true;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException coreException) {}
        }
        PProjectSourceLocation pProjectSourceLocation = this;
        synchronized (pProjectSourceLocation) {
            if (this.fFolders == null) {
                this.fFolders = list.toArray(new IResource[list.size()]);
            }
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private boolean notFoundCacheLookup(String name) {
        return this.fNotFoundCache.contains(name);
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    protected IResource[] getFolders() {
        if (this.fFolders == null) {
            this.initializeFolders();
        }
        return this.fFolders;
    }
}

