/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.gem.popup.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.gem.GemPlugin;
import org.eclipse.ptp.gem.messages.Messages;
import org.eclipse.ptp.gem.util.GemUtilities;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ProcessLogFilePopUpAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (this.selection.toString().equals("<empty selection>")) {
            GemUtilities.showErrorDialog(Messages.ProcessLogFilePopUpAction_0);
        } else {
            IFile logFile = (IFile)this.selection.getFirstElement();
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
            try {
                String activeView = pstore.getString("activeViewPreference");
                if (activeView.equals("analyzer")) {
                    page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                    page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                } else {
                    page.showView("org.eclipse.ptp.gem.views.GemAnalyzer");
                    page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                }
            }
            catch (PartInitException e) {
                GemUtilities.logExceptionDetail((Exception)((Object)e));
            }
            String projectName = logFile.getProject().getName();
            IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            GemUtilities.refreshProject(currentProject);
            if (logFile.exists()) {
                GemUtilities.initGemViews(logFile, false, false);
            } else {
                GemUtilities.showErrorDialog(Messages.ProcessLogFilePopUpAction_1);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

