/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;

public class RemoteSearchTextSelectionQuery
extends RemoteSearchQuery {
    private static final long serialVersionUID = 1L;
    private ITranslationUnit tu;
    private String selection;
    private int offset;
    private int length;

    public RemoteSearchTextSelectionQuery(ICElement[] scope, ITranslationUnit tu, String selection, int offset, int length, int flags) {
        super(scope, flags | 8);
        this.tu = tu;
        this.selection = selection;
        this.offset = offset;
        this.length = length;
    }

    public void runWithIndex(IIndex parseIndex, IIndex searchScopeindex, IIndexLocationConverter converter, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IBinding binding;
        block11: {
            this.fConverter = converter;
            binding = null;
            parseIndex.acquireReadLock();
            try {
                IASTName searchName;
                IASTTranslationUnit ast = this.tu.getAST(parseIndex, 2);
                if (ast == null || (searchName = ast.getNodeSelector(null).findEnclosingName(this.offset, this.length)) == null) break block11;
                this.selection = searchName.toString();
                binding = searchName.resolveBinding();
                if (binding instanceof IProblemBinding) break block11;
                if (binding != null) {
                    IScope scope = null;
                    try {
                        scope = binding.getScope();
                    }
                    catch (DOMException dOMException) {}
                    if (scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                        this.createLocalMatches(ast, binding);
                    }
                }
                binding = parseIndex.findBinding((IName)searchName);
            }
            finally {
                parseIndex.releaseReadLock();
            }
        }
        if (binding != null) {
            searchScopeindex.acquireReadLock();
            try {
                this.createMatches(searchScopeindex, binding);
            }
            finally {
                searchScopeindex.releaseReadLock();
            }
        }
    }

    public String getSelection() {
        return this.selection;
    }
}

